% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2prob.R
\name{convert2prob}
\alias{convert2prob}
\alias{expandthresh}
\alias{prob2thresh}
\title{Convert to Probability / Category Forecast}
\usage{
convert2prob(x, prob = NULL, threshold = NULL, ref.ind = NULL,
  multi.model = FALSE)

prob2thresh(x, prob, ref.ind = NULL, multi.model = FALSE)

expandthresh(threshold, x)
}
\arguments{
\item{x}{input vector or matrix}

\item{prob}{thresholds for categorical forecasts (defaults to NULL)}

\item{threshold}{absolute thresholds for categorical forecasts (defaults to 
NULL)}

\item{ref.ind}{list of forecast/obs instances to be used to estimate 
percentile thresholds}

\item{multi.model}{logical, are we dealing with initial condition (the 
default) or multi-model ensembles (see details)?}
}
\value{
Matrix of occurences per class (i.e. the number of ensemble members 
  per class, or an indicator for the observations)
}
\description{
\code{convert2prob} Converts the continuous ensemble forecast to
counts of ensemble members per category. The categories can be defined
relative to the ensemble distribution (using \code{prob}) or relative to
absolute values for the category thresholds (using \code{threshold}, see
details). \code{prob2thresh} converts the relative threshold to absolute
thresholds for later processing. \code{expandthresh} expands the vector or
matrix of thresholds to fit the input data.
}
\details{
In case both \code{prob} and \code{threshold} are set to 
  \code{NULL}, the function returns the input \code{x} without modification.
  If \code{prob} is set, a matrix with the number of occurences per class for
  a given quantile of the full distribution (e.g. temperature above/below the
  median). If \code{threshold} is set, the classes are defined based on the 
  absolute value (e.g. temperature above/below 13 deg. C). Multiple classes
  are
  
  Only certain formats of \code{threshold} and \code{prob} are supported.
  \code{prob} has to be a vector with percentile thresholds separating the
  different classes. \code{threshold} can be a vector, matrix or array with
  the first entry corresponding to the different classes, and the last to the
  different ensemble members (if present). Thereby, time/forecast varying
  thresholds can potentially be supplied (although I am not sure this is
  useful or needed).
  
  If \code{ref.ind} is specified, only the specified indices of the input
  variables are used to estimate the percentile thresholds (\code{prob}). If
  used with \code{threshold}, or without anything, \code{ref.ind} has no effect. 
  
  If \code{multi.model = TRUE}, the relative thresholds supplied by
  \code{prob} are ensemble member specific, i.e. are estimated for each
  ensemble member separately. This is in particular applicable for
  multi-model ensembles with model dependent biases.
}
\examples{
tm <- toymodel()

## convert to tercile forecasts (only display first forecast and obs)
convert2prob(tm$fcst, prob=1:2/3)[1,]
convert2prob(tm$obs, prob=1:2/3)[1,]

## convert to category forecasts (smaller and larger than 1)
convert2prob(tm$fcst, threshold=1)[1,]
convert2prob(tm$obs, threshold=1)[1,]

}
\seealso{
\code{\link{veriApply}}
}
\keyword{utilities}

