% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easylabel.R
\name{easylabel}
\alias{easylabel}
\title{Interactive scatter plot labels}
\usage{
easylabel(
  data,
  x,
  y,
  labs = NULL,
  startLabels = NULL,
  cex.text = 0.72,
  col = NULL,
  colScheme = NULL,
  alpha = 1,
  shape = NULL,
  shapeScheme = 21,
  size = 8,
  sizeRange = c(4, 80),
  xlab = x,
  ylab = y,
  xlim = NULL,
  ylim = NULL,
  showOutliers = TRUE,
  outlier_shape = 5,
  outline_col = "white",
  outline_lwd = 0.5,
  width = 800,
  height = 600,
  showgrid = FALSE,
  zeroline = TRUE,
  hline = NULL,
  vline = NULL,
  mgp = c(1.8, 0.5, 0),
  Ltitle = "",
  Rtitle = "",
  LRtitle_side = 1,
  labelDir = "radial",
  labCentre = NULL,
  text_col = "black",
  line_col = "black",
  rectangles = FALSE,
  rect_col = "white",
  border_col = "black",
  padding = 3,
  border_radius = 5,
  filename = NULL,
  panel.last = NULL,
  fullGeneNames = FALSE,
  AnnotationDb = NULL,
  custom_annotation = NULL,
  ...
)
}
\arguments{
\item{data}{Dataset to use for plot.}

\item{x}{Specifies column of x coordinates in \code{data}.}

\item{y}{Specifies column of y coordinates in \code{data}.}

\item{labs}{Specifies the column in \code{data} with label names for points.
If \code{NULL} defaults to \code{rownames(data)}.}

\item{startLabels}{Vector of initial labels.}

\item{cex.text}{Font size for labels. Default 0.72 to match plotly font size.
See \code{\link[=text]{text()}}.}

\item{col}{Specifies which column in \code{data} affects point colour. Must be
categorical. If it is not a factor, it will be coerced to a factor.}

\item{colScheme}{A single colour or a vector of colours for points.}

\item{alpha}{Alpha value for transparency of points.}

\item{shape}{Specifies which column in \code{data} controls point shapes. If not a
factor, will be coerced to a factor.}

\item{shapeScheme}{A single symbol for points or a vector of symbols.
See \code{pch} in \code{\link[=points]{points()}}.}

\item{size}{Either a single value for size of points (default 8), or
specifies which column in \code{data} affects point size for bubble charts.}

\item{sizeRange}{Range of size of points for bubble charts.}

\item{xlab}{x axis title. Accepts expressions when exporting base graphics.
Set \code{cex.lab} to alter the font size of the axis titles (default 1).
Set \code{cex.axis} to alter the font size of the axis numbering (default 1).}

\item{ylab}{y axis title. Accepts expressions when exporting base graphics.}

\item{xlim}{The x limits (x1, x2) of the plot.}

\item{ylim}{The y limits of the plot.}

\item{showOutliers}{Logical whether to show outliers on the margins of the
plot.}

\item{outlier_shape}{Symbol for outliers.}

\item{outline_col}{Colour of symbol outlines. Set to \code{NA} for no outlines.}

\item{outline_lwd}{Line width of symbol outlines.}

\item{width}{Width of the plot in pixels. Saving to pdf scales 100 pixels to
1 inch.}

\item{height}{Height of the plot in pixels.}

\item{showgrid}{Logical whether to show gridlines.}

\item{zeroline}{Logical whether to show lines at x = 0 and y = 0.}

\item{hline}{Adds horizontal lines at values of y.}

\item{vline}{Adds vertical lines at values of x.}

\item{mgp}{The margin line for the axis title, axis labels and axis line.
See \code{\link[=par]{par()}}.}

\item{Ltitle}{A character or expression (see \link{plotmath}) value specifying
text for left side title. Size of font can be changed using \code{cex.lab}.}

\item{Rtitle}{A character or expression value specifying text for right side
title. Size of font can be changed using \code{cex.lab}.}

\item{LRtitle_side}{On which side of the plot for \code{Ltitle} and \code{Rtitle}
(1 = bottom, 3 = top). See \code{\link[=mtext]{mtext()}}.}

\item{labelDir}{Initial label line directions. Options include 'radial'
(default) for radial lines around the centre of the plot,
'origin' for radial lines around the origin,
'horiz' for horizontal and 'vert' for vertical,
'xellipse' and 'yellipse' for near-horizontal and near-vertical lines
arranged in an elliptical way around the centre,
'rect' for rectilinear lines (a mix of horizontal and vertical),
'x' for diagonal lines,
'oct' for lines in 8 directions around the centre.}

\item{labCentre}{Coordinates in x/y units of the central point towards which
radial labels converge. Defaults to the centre of the plot.}

\item{text_col}{Colour of label text. (Not supported by plotly.)}

\item{line_col}{Colour of label lines. (Not supported by plotly.)}

\item{rectangles}{Logical whether to show rectangles around labels.
(Not supported by plotly.)}

\item{rect_col}{Colour for filling rectangles. (Not supported by plotly.)}

\item{border_col}{Colour of rectangle borders. Use \code{border_col = NA} to omit
borders. (Not supported by plotly.)}

\item{padding}{Amount of padding in pixels around label text.}

\item{border_radius}{Amount of roundedness in pixels to apply to label
rectangles. (Not supported by plotly.)}

\item{filename}{Filename for saving plots to pdf.}

\item{panel.last}{An expression to be evaluated after plotting has taken
place but before the axes, title and box are added. This can be useful for
adding extra titles, legends or trend lines. Currently only works when saving
plots using base graphics and does not work with plotly. See \link{plot.default}}

\item{fullGeneNames}{Logical whether to expand gene symbols using
Bioconductor AnnotationDbi package. With multiple matches, returns first
value only.
See \code{\link[AnnotationDbi:AnnotationDb-class]{AnnotationDbi::mapIds()}}.}

\item{AnnotationDb}{Annotation database to use when expanding gene symbols.
Defaults to human gene database \code{AnnotationDb = org.Hs.eg.db}.}

\item{custom_annotation}{List of annotations to be added via
\code{\link[plotly:layout]{plotly::layout()}}.}

\item{...}{Further graphical parameters passed to \code{plot()} when saving via
base graphics. The most useful for most users are likely to be \code{cex.lab}
which alters axis title font size (default 1, see \code{\link[=par]{par()}}), \code{cex.axis} which
alters axis numbering font size (default 1), and \code{panel.last} which allows
additional plotting functions to be called after the main plot has been
plotted but before the labels and label lines are drawn, which will allow the
addition of trend lines, extra titles or legends for example (see
\code{\link[=plot.default]{plot.default()}}).}
}
\value{
No return value
}
\description{
Interactive labelling of scatter plots using shiny/plotly interface.
}
\details{
Instructions:
\itemize{
\item Hover over and click on/off genes which you want to label.
\item When you have selected all your chosen genes, then drag gene names to
move label positions.
\item Click the save button to export a PDF in base graphics.
\item The Table tab shows a table view of the dataset to help with annotation.
}

To export an SVG from plotly:
\itemize{
\item You can move the legend as well.
\item Switch to SVG when finalised (only do this at last moment as otherwise
editing is very slow).
\item Press camera button in modebar to save image as SVG.
}
}
\examples{

# Simple example using mtcars dataset
data(mtcars)
# Launch easylabel Shiny app: only run this example in interactive R sessions
if (interactive()) {
easylabel(mtcars, x = 'mpg', y = 'wt', col = 'cyl')
}
}
\seealso{
\code{\link[=easyVolcano]{easyVolcano()}}, \code{\link[=easyMAplot]{easyMAplot()}}
}
