% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiencyRFEAT.R
\name{efficiencyRFEAT}
\alias{efficiencyRFEAT}
\title{Random Forest + Efficiency Analysis Trees Efficiency Scores}
\usage{
efficiencyRFEAT(data, x, y, object, digits = 3, FDH = TRUE, na.rm = TRUE)
}
\arguments{
\item{data}{Dataframe for which the efficiency score is calculated.}

\item{x}{Vector. Column input indexes in data.}

\item{y}{Vector. Column output indexes in data.}

\item{object}{A RFEAT object.}

\item{digits}{Integer. Decimal units for scores.}

\item{FDH}{Logical. If \code{TRUE}, FDH scores are computed.}

\item{na.rm}{Logical. If \code{TRUE}, \code{NA} rows are omitted.}
}
\value{
Dataframe with input variables and efficiency scores through a Random Forest + Efficiency Analysis Trees model.
}
\description{
This function calculates the efficiency scores for each DMU through a Random Forest + Efficiency Analysis Trees model and the Banker Charnes and Cooper mathematical programming model with output orientation.
}
\examples{
\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
RFEAT_model <- RFEAT(data = simulated, x = c(1,2), y = c(3, 4))

efficiencyRFEAT(data = simulated, x = c(1, 2), y = c(3, 4), object = RFEAT_model, 
                digits = 2, FDH = TRUE, na.rm = TRUE)
}

}
