% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/userPredictions.R
\name{predictEAT}
\alias{predictEAT}
\title{Model Prediction for Efficiency Analysis Trees.}
\usage{
predictEAT(object, newdata, x)
}
\arguments{
\item{object}{An EAT object.}

\item{newdata}{Dataframe. Set of input variables to predict on.}

\item{x}{Inputs index.}
}
\value{
Data frame with the original data and the predicted values.
}
\description{
This function predicts the expected output by an EAT object.
}
\examples{

\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
EAT_model <- EAT(data = simulated, x = c(1,2), y = c(3, 4))

predictEAT(object = EAT_model, newdata = simulated, x = c(1,2))
}

}
