% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummiesToFactor.R
\name{dummiesToFactor}
\alias{dummiesToFactor}
\title{Convert dummy variables to factor.}
\usage{
dummiesToFactor(dat, dummies, facVar, nameEmptyCategory = "_none_")
}
\arguments{
\item{dat}{A \code{data.frame}.}

\item{dummies}{Character vector containing the names of the dummy variables in the \code{data.frame}.}

\item{facVar}{Name of the factor variable, that should be created.}

\item{nameEmptyCategory}{a character of length 1 that defines the name of cases
for which no dummy is equal to one.}
}
\value{
A \code{data.frame} containing the newly created factor.
}
\description{
Convert multiple dummy variables into a single factor variable.
}
\details{
The content of a single factor variable can alternatively be stored in multiple dichotomous dummy variables coded with \code{0}/\code{1} or \code{NA}/\code{1}. \code{1} always has to refer to "this category applies". The function requires factor levels to be exclusive (i.e. only one factor level applies per row.).
}
\examples{
# Example data set
tdat <- data.frame(ID = 1:3, d1=c(1, 0, 0), d2 = c(0, 1, 0), d3 = c(0, 0, 1))

dummiesToFactor(tdat, dummies = c("d1", "d2", "d3"), facVar = "newFac")

}
