% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemValuesConstraint.R
\name{itemValuesConstraint}
\alias{itemValuesConstraint}
\title{Constrain the sum of item values per form.}
\usage{
itemValuesConstraint(
  nForms,
  itemValues,
  operator = c("<=", "=", ">="),
  targetValue,
  whichForms = seq_len(nForms),
  info_text = NULL,
  itemIDs = names(itemValues)
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{itemValues}{Item parameter/values for which the sum per test form should be constrained.}

\item{operator}{A character indicating which operator should be used in the
constraints, with three possible values: \code{"<="}, \code{"="},
or \code{">="}. See details for more information.}

\item{targetValue}{the target test form value.}

\item{whichForms}{An integer vector indicating which test forms should be constrained. Defaults to all the test forms.}

\item{info_text}{a character string of length 1, to be used in the \code{"info"}-attribute of the resulting \code{constraint}-object.}

\item{itemIDs}{a character vector of item IDs in correct ordering, or NULL.}
}
\value{
An object of class \code{"constraint"}.
}
\description{
Create constraints related to an item parameter/value. That is, the created
constraints assure that the sum of the item values (\code{itemValues}) per test form is either
(a) smaller than or equal to (\code{operator = "<="}), (b) equal to
(\code{operator = "="}), or (c) greater than or equal to (\code{operator = ">="})
the chosen \code{targetValue}.
}
\examples{
## constraints to make sure that the sum of the item values (1:10) is between
## 4 and 6
combineConstraints(
  itemValuesConstraint(2, 1:10, operator = ">=", targetValue = 4),
  itemValuesConstraint(2, 1:10, operator = "<=", targetValue = 6)
)

}
