% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-ppms.R
\name{compute_ppms}
\alias{compute_ppms}
\title{Computes the Predictive Performance Metrics for a spatiotemporal extent}
\usage{
compute_ppms(path, ext)
}
\arguments{
\item{path}{character; full path to directory containing the eBird Status and
Trends products for a single species.}

\item{ext}{\link{ebirdst_extent} object (optional); the spatiotemporal extent to
filter the data to.}
}
\value{
A list of three data frames: \code{binary_ppms}, \code{occ_ppms}, and
\code{abd_ppms}. These data frames have 25 rows corresponding to 25 Monte Carlo
iterations each estimating the PPMs using a spatiotemporal subsample of the
test data. Columns correspond to the different PPMS. \code{binary_ppms} contains
binary or range-based PPMS, \code{occ_ppms} contains within-range occupancy
probability PPMS, and \code{abd_ppms} contains within-range abundance PPMs. In
some cases, PPMs may be missing, either because there isn't a large enough
test set within the spatiotemporal extent or because average occurrence or
abundance is too low. In these cases, try increasing the size of the
\link{ebirdst_extent} object.
}
\description{
Loads test data and ensemble support values and then calculates the
predictive performance metrics (PPMs) within a spatiotemporal extent defined by an
\link{ebirdst_extent} object. Use this function directly to access the computed
metrics, or use \code{plot_all_ppms()} or \code{plot_binary_by_time()} to summarize the
metrics.
}
\examples{

# download and load example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)

# define a spatiotemporal extent to plot
bb_vec <- c(xmin = -86, xmax = -83, ymin = 41.5, ymax = 43.5)
e <- ebirdst_extent(bb_vec, t = c("05-01", "05-31"))
\donttest{
# compute predictive performance metrics
ppms <- compute_ppms(path = sp_path, ext = e)
}
}
