% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{label_raster_stack}
\alias{label_raster_stack}
\title{Label data cubes with the week date for each band}
\usage{
label_raster_stack(x, weeks = NULL)
}
\arguments{
\item{x}{\code{RasterStack} or \code{RasterBrick}; eBird Status and Trends data cube,
typically with 52 bands, one for each week.}

\item{weeks}{vector of dates corresponding to the weeks of each layer in \code{x}.
This argument should be used only rarely, when you're labelling a cube with
fewer that the usual 52 weeks of predictions.}
}
\value{
A \code{RasterStack} or \code{RasterBrick} with names assigned for the dates in
the format of "wYYYY.MM.DD" per raster package constraints. The \verb{Raster*}
objects do not allow the names to start with a number, nor are they allowed
to contain "-", so it is not possible to store the date in an ISO compliant
format. Use \code{parse_raster_dates()} to convert the layer names to dates.
}
\description{
The data cubes are saved as GeoTIFFs, which don't allow for band labels. For
convenience, this function labels the layers of a data cube once it has been
loaded with the week dates for each band.
}
\examples{
\dontrun{
# download example data
path <- ebirdst_download("example_data")
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# weekly relative abundance
# note that only low resolution (lr) data are available for the example data
abd <- load_raster(path, "abundance", resolution = "lr")

# label
abd <- label_raster_stack(abd)
names(abd)
}
}
