% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-mgf-term-method.R
\name{ecld.mgf_term}
\alias{ecld.mgf_diterm}
\alias{ecld.mgf_term}
\alias{ecld.mgf_trunc}
\alias{ecld.mgf_trunc_max_sigma}
\title{The term structure of ecld symmetric MGF}
\usage{
ecld.mgf_term(object, order, t = 1)

ecld.mgf_diterm(object, order, t = 1)

ecld.mgf_trunc(object, t = 1)

ecld.mgf_trunc_max_sigma(object, order = 1)
}
\arguments{
\item{object}{an object of ecd class}

\item{order}{numeric. Order of the term (moment)}

\item{t}{numeric, for MGF}
}
\value{
numeric
}
\description{
\code{ecld.mgf_term} and \code{ecld.mgf_diterm} are the term and derivative
of the term by order (n) in the summation of MGF.
\code{ecld.mgf_trunc} uses \code{ecld.mgf_diterm} to locate the truncation
of MGF terms.
\code{ecld.mgf_trunc_max_sigma} locates the maximum sigma that keeps MGF finite for each lambda.
SGED is supported.
}
\examples{
ld <- ecld(3, sigma=0.01*ecd.mp1)
ecld.mgf_trunc(ld)

}
\author{
Stephen H-T. Lihn
}
\keyword{moment}

