% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lamp-simulate-iter-method.R
\name{lamp.simulate_iter}
\alias{lamp.simulate_iter}
\title{Simulate lambda process from stable distribution iteratively}
\usage{
lamp.simulate_iter(
  object,
  use.mc = 4,
  sim.length = 1000,
  reset.cache = FALSE,
  drop = 10,
  keep.tau = 1,
  plot.util = lamp.plot_sim6,
  cpu.temperature = 68,
  cpu.temperature.util = NULL
)
}
\arguments{
\item{object}{an object of lamp class}

\item{use.mc}{numeric, number of cores for parallel simulations. Default is 4.}

\item{sim.length}{numeric, number of Z to simulate. Default is 1000.}

\item{reset.cache}{logical, to reset simulation cache or not prior the run. Default is FALSE.}

\item{drop}{numeric, number of tau to discard at the end per iteration. Default is 10.}

\item{keep.tau}{numeric, 0 to clean up, 1 to return unused tau, 2 to return all tau. Default is 1.}

\item{plot.util}{function, interface to plot simulation results. Default is lamp.plot_sim4.}

\item{cpu.temperature}{numeric, temperature above which is overhead. Default is 68.}

\item{cpu.temperature.util}{function, interface to get CPU temperature. Default is NULL.}
}
\value{
an object of lamp class with Z, B, N populated
}
\description{
Simulate lambda process from stable distribution iteratively 
until target length of result is reached. It uses multi-core capability to 
run lamp.simulate1 in parallel. 
If file slot is specified, simulation result will be persisted to it periodically.
A plot interface is provided to monitor the progress.
A CPU temperature interface is provided to control CPU from overheating.
}
\author{
Stephen H-T. Lihn
}
\keyword{simulation}
