% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{e_brush}
\alias{e_brush}
\title{Brush}
\usage{
e_brush(e, x.index = NULL, y.index = NULL, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{x.index}{Indexes of x and y axis.}

\item{y.index}{Indexes of x and y axis.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add a brush.
}
\examples{
quakes \%>\% 
  e_charts(long) \%>\% 
  e_geo(
    boundingCoords = list(
      c(190, -10),
      c(180, -40)
     )
  ) \%>\% 
  e_scatter(lat, mag, stations, coord.system = "geo", scale = "* 1.5", name = "mag") \%>\% 
  e_data(quakes, depth) \%>\% 
  e_scatter(mag, mag, stations, scale = "* 3", name = "mag & depth") \%>\%  
  e_grid(right = 40, top = 100, width = "30\%") \%>\% 
  e_y_axis(type = "value", name = "depth", min = 3.5) \%>\% 
  e_brush() \%>\% 
  e_theme("dark")

}
\seealso{
\href{Additional arguments}{https://ecomfe.github.io/echarts-doc/public/en/option.html#brush}
}
