% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{e_toolbox_feature}
\alias{e_toolbox_feature}
\alias{e_toolbox}
\title{Toolbox}
\usage{
e_toolbox_feature(e, feature, ...)

e_toolbox(e, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{feature}{Feature to add, defaults to all.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add toolbox interface.
}
\details{
Valid \code{feature}:
\itemize{
  \item{\code{saveAsImage}}
  \item{\code{brush}}
  \item{\code{restore}}
  \item{\code{dataView}}
  \item{\code{dataZoom}}
  \item{\code{magicType}}
}
}
\examples{
USArrests \%>\%
  e_charts(UrbanPop) \%>\%
  e_line(Assault) \%>\%
  e_area(Murder, y_index = 1, x_index = 1) \%>\%
  e_datazoom(x_index = 0)

mtcars \%>\%
  dplyr::mutate(model = row.names(.)) \%>\%
  e_charts(model) \%>\%
  e_line(qsec) \%>\%
  e_toolbox() \%>\%
  e_toolbox_feature(
    feature = "magicType",
    type = list("line", "bar")
  )
}
\seealso{
\href{https://echarts.apache.org/en/option.html#toolbox}{Additional arguments}
}
