% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_screen_summarise}
\alias{ec_screen_summarise}
\alias{ec_screen_summarize}
\title{Summarize posterior draws of screening}
\usage{
ec_screen_summarise(sc, quantiles = c(0.05, 0.95))

ec_screen_summarize(sc, quantiles = c(0.05, 0.95))
}
\arguments{
\item{sc}{tibble containing screening draws in .screendraws}

\item{quantiles}{Quantiles for Credibility Intervals (default: 90\% interval)}
}
\value{
Summary of screening probabilities
}
\description{
Adds summaries of posterior draws of demand to tibble.
(using the new demand draw format)
}
\examples{
\donttest{
data(icecream)
icecream_est <- icecream \%>\% vd_est_vdm_screen(R=20,  price_screen=TRUE, cores=2)
#consideration set by respondent
cons_ss <- 
ec_screenprob_sr(icecream, icecream_est, cores=2) \%>\%
group_by(id, task)  \%>\%
  summarise(.screendraws=list(purrr::reduce(.screendraws ,`+`))) \%>\%
  ec_screen_summarise() \%>\%
  group_by(id) \%>\%
  summarise(n_screen=mean(`E(screening)`))
  }
}
