% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecm.R
\name{ecm}
\alias{ecm}
\title{Build an error correction model}
\usage{
ecm(y, xeq, xtr)
}
\arguments{
\item{y}{The target variable}

\item{xeq}{The variables to be used in the equilibrium term of the error correction model}

\item{xtr}{The variables to be used in the transient term of the error correction model}
}
\value{
an lm object representing an error correction model
}
\description{
Builds an lm object that represents an error correction model (ECM) by automatically differencing and
lagging predictor variables according to ECM methodology.
}
\details{
The general format of an ECM is \deqn{\Delta y = \beta_{0} + \beta_{1}\Delta x_{1,t} +...+ \beta_{i}\Delta x_{i,t} + \gamma(y_{t-1} - (x1_{t-1} +...+ x_{i,t-1})).}
The ecm function here modifies the equation to the following: \deqn{\Delta y = \beta_{0} + \beta_{1}\Delta x_{1,t} +...+ \beta_{i}\Delta x_{i,t} + \gamma y_{t-1} + \gamma_{1}x_{1,t-1} +...+ \gamma_{i}x_{i,t-1},}
so it can be modeled as a simpler ordinary least squares (OLS) function using R's lm function.

Notice that an ECM models the change in the target variable (y). This means that the predictors will be lagged and differenced,
and the model will be built on one observation less than what the user inputs for y, xeq, and xtr. If these arguments contain vectors with too few observations (eg. one single observation),
the function will not work.

ECM models are used for time series data. This means the user may need to consider stationarity and/or cointegration before using the model.
}
\examples{
#Use ecm to predict Fed Funds Rate based on Unemployment Rate, Inflation, and GDP Growth
data(FedData)

#Use 2015-12-01 and earlier data to build models
trn <- FedData[FedData$date<='2015-12-01',]

#Assume all predictors are needed in the equilibrium and transient terms of ecm
xeq <- xtr <- trn[c('UnemploymentRate', 'Inflation', 'GDPgrowth')]
model1 <- ecm(trn$FedFundsRate, xeq, xtr)

#Assume Unemployment Rate is in the equilibrium term, 
#Inflation and GDPgrowth have only transient impacts
xeq <- trn['UnemploymentRate']
xtr <- trn[c('Inflation', 'GDPgrowth')]
model2 <- ecm(trn$FedFundsRate, xeq, xtr)

}
\seealso{
\code{lm}
}

