% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scompvar.R
\name{scompvar}
\alias{scompvar}
\alias{compvar}
\title{Simulated components of variation}
\usage{
scompvar(data, n = NULL, m = NULL)
}
\arguments{
\item{data}{Object of class "ecocbo_beta" that results from \code{\link[=sim_beta]{sim_beta()}}.}

\item{n}{Number of samples to be considered. Defaults to NULL.}

\item{m}{Site label to be used as basis for the computation. Defaults to NULL.}
}
\value{
A data frame containing the values for the variation component
among sites \code{compVarA} and in the residuals \code{compVarR}.
}
\description{
\code{scompvar} can be used to calculate the average component of variation
among units and the average component of variation within samples in terms
of sampling effort.
}
\note{
If \code{m} or \code{n} are left as NULL, the function will calculate
the components of variation using the largest available values as set in
the experimental design in \code{\link[=sim_beta]{sim_beta()}}.
}
\examples{
scompvar(data = epiBetaR)
scompvar(data = epiBetaR, n = 5, m = 2)
}
\references{
Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.

Underwood, A. J., & Chapman, M. G. (2003). Power, precaution,
Type II error and sampling design in assessment of environmental impacts.
Journal of Experimental Marine Biology and Ecology, 296(1), 49-70.
}
\seealso{
\code{\link[=sim_beta]{sim_beta()}}
\code{\link[=plot_power]{plot_power()}}
\code{\link[=sim_cbo]{sim_cbo()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
