% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_beta.R
\name{sim_beta}
\alias{sim_beta}
\alias{simbeta}
\title{Calculate beta and power out of simulated samples}
\usage{
sim_beta(
  simH0,
  simHa,
  n,
  m,
  k = 50,
  alpha = 0.05,
  transformation = "none",
  method = "bray",
  dummy = FALSE,
  useParallel = FALSE
)
}
\arguments{
\item{simH0}{Simulated community from \code{SSP::simdata()} in which H0 is
true.}

\item{simHa}{Simulated community from \code{SSP::simdata()} in which H0 is
false.}

\item{n}{Maximum number of samples to consider.}

\item{m}{Maximum number of sites.}

\item{k}{Number of resamples the process will take. Defaults to 50.}

\item{alpha}{Level of significance for Type I error. Defaults to 0.05.}

\item{transformation}{Mathematical function to reduce the weight of very
dominant species: 'square root', 'fourth root', 'Log (X+1)', 'P/A', 'none'}

\item{method}{The appropriate distance/dissimilarity metric (e.g. Gower,
Bray–Curtis, Jaccard, etc). The function \code{\link[vegan:vegdist]{vegan::vegdist()}} is called for
that purpose.}

\item{dummy}{Logical. It is recommended to use TRUE in cases where there are
observations that are empty.}

\item{useParallel}{Logical. Perform the analysis in parallel? Defaults to FALSE.}
}
\value{
\code{sim_data()} returns an object of class "ecocbo_beta".

The function \code{print()} is used to present a matrix that summarizes the
results by showing the estimate power according to different sampling efforts.

An object of class "ecocbo_beta" is a list containing the following components:
\itemize{
\item \code{$Power} a data frame containing the estimation of power and beta for
several combination of sampling efforts (\code{m} sites and \code{n} samples).
\item \code{$Results} a data frame containing the estimates of pseudoF for \code{simH0}
and \code{simHa}.
\item \code{$alpha} level of significance for Type I error.
}
}
\description{
\code{sim_beta()} can be used to assess the power of a study by comparing the
variation when one can assume wether an ecological community does not have
composition differences (H0 true) or it does (H0 false). For example, if the
beta error is 0.25, then there is a 25\% chance of failing to detect a
difference even if the difference is real. The power of the study is
\eqn{1 - \beta}, so in this example, the power of the study is 0.75.
}
\examples{
\donttest{
sim_beta(simH0Dat, simHaDat, n = 5, m = 4, k = 30, alpha = 0.05,
         transformation = "square root", method = "bray", dummy = FALSE,
         useParallel = FALSE)
}

}
\references{
Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.

Underwood, A. J., & Chapman, M. G. (2003). Power, precaution,
Type II error and sampling design in assessment of environmental impacts.
Journal of Experimental Marine Biology and Ecology, 296(1), 49-70.

Anderson, M. J. (2014). Permutational multivariate analysis of
variance (PERMANOVA). Wiley statsref: statistics reference online, 1-15.

Guerra‐Castro, E. J., Cajas, J. C., Simões, N., Cruz‐Motta, J.
J., & Mascaró, M. (2021). SSP: an R package to estimate sampling effort in
studies of ecological communities. Ecography, 44(4), 561-573.
}
\seealso{
\code{\link[=plot_power]{plot_power()}}
\code{\link[=scompvar]{scompvar()}}
\code{\link[=sim_cbo]{sim_cbo()}}
\code{\link[SSP:assempar]{SSP::assempar()}}
\code{\link[SSP:simdata]{SSP::simdata()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
