% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexity_measures.R
\name{ec_complexity_measures}
\alias{ec_complexity_measures}
\title{Complexity Measures}
\usage{
ec_complexity_measures(rca = NULL, c = "country", p = "product",
  v = "value", method = "fitness", iterations = 20,
  extremality = 1, atlas = FALSE, tbl = FALSE)
}
\arguments{
\item{rca}{matrix or tibble/data.frame (e.g. the
output of \code{revealed_comparative_advantage()}).
If the input is a matrix it must be a zero/one matrix with countries in rows
and ps in columns.
If the input is a tibble/data.frame it must contain at least three columns
with countries, ps and vs.}

\item{c}{string to indicate the column that contains exporting
countries in rca (set to "country" by default)}

\item{p}{string to indicate the column that contains exported ps
in rca (set to "product" by default)}

\item{v}{string to indicate the column that contains traded vs in
rca (set to "value" by default)}

\item{method}{string to indicate to use one of these methods: reflections,
eigenvalues or fitness (set to "fitness" by default)}

\item{iterations}{number of iterations to use in the reflections method
(set to 20 by default)}

\item{extremality}{numeric coefficient to use in the fitness method
(set to 1 by default)}

\item{atlas}{logical v to remove the countries not ranked in The
Atlas of Economic Complexity (set to FALSE by default)}

\item{tbl}{logical v to use tibble output instead of a matrix
output (set to FALSE by default)}
}
\description{
Complexity Measures
}
\examples{
ec_complexity_measures(
  rca = ec_output_demo$rca_tbl,
  tbl = TRUE
)

}
\references{
For more information on complexity measures, indices and its applications
see:

\insertRef{atlas2014}{economiccomplexity}

\insertRef{measuringcomplexity2015}{economiccomplexity}
}
\keyword{functions}
