% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeDominatedHypervolume.R
\name{computeDominatedHypervolume}
\alias{computeDominatedHypervolume}
\alias{computeHypervolumeContribution}
\title{Functions for the calculation of the dominated hypervolume (contribution).}
\usage{
computeDominatedHypervolume(x, ref.point = NULL)

computeHypervolumeContribution(x, ref.point = NULL, offset = 1)
}
\arguments{
\item{x}{[\code{matrix}]\cr
Matrix of points (column-wise).}

\item{ref.point}{[\code{numeric} | \code{NULL}]\cr
Reference point. Set to the maximum in each dimension by default if not provided.}

\item{offset}{[\code{numeric(1)}]\cr
Offset to be added to each component of the reference point only in the case
where no reference is provided and one is calculated automatically.}
}
\value{
[\code{numeric(1)}] Dominated hypervolume in the case of
 \code{computeDominatedHypervolume} and the dominated hypervolume of a single
 point in the case of \code{computeHypervolumeContribution}.
}
\description{
The function \code{computeDominatedHypervolume} computes the dominated
hypervolume of a set of points given a reference set whereby
\code{computeHypervolumeContribution} computes the hypervolume contribution
of each point.

If no reference point is given the nadir point of the set \code{x} is
determined and a positive offset with default 1 is added. This is to ensure
that the reference point dominates all of the points in the reference set.
}

