% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paretoArchive.R
\name{updateParetoArchive}
\alias{updateParetoArchive}
\title{Update Pareto Archive.}
\usage{
updateParetoArchive(archive, inds, fitness, ...)
}
\arguments{
\item{archive}{[\code{ecr_pareto_archive}]\cr
The archive generated by \code{\link{initParetoArchive}}.}

\item{inds}{[\code{list}]\cr
List of individuals.}

\item{fitness}{[\code{matrix}]\cr
Matrix of fitness values (each column contains the fitness value(s) for
one individual) of \code{inds}.}

\item{...}{[any]\cr
Furhter arguments passed down to \code{trunc.fun} (set via \code{\link{initParetoArchive}}).}
}
\description{
This function updates a Pareto archive, i.e., an archive of non-dominated
points. It expects the archive, a set of individuals, a matrix of fitness values
(each column corresponds to the fitness vector of one individual) and updates
the archive \dQuote{in-place}. If the archive has unlimited capacity all non-dominated points of
the union of archive and passed individuals are stored. Otherwise, i.e., in case
the archive is limited in capacity (argument \code{max.size} of
\code{\link{initParetoArchive}} was set to an integer value greater zero), the
\code{trunc.fun} function passed to \code{\link{initParetoArchive}} is applied to
all non-dominated points to determine which points should be dropped.
}
\seealso{
Other ParetoArchive: \code{\link{getIndividuals}},
  \code{\link{getSize}}, \code{\link{initParetoArchive}}
}
