% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigger_borders.R
\name{big_borders}
\alias{big_borders}
\title{A function to model local revenue pooling}
\usage{
big_borders(data_year= "2018", pooling_level = "county")
}
\arguments{
\item{data_year}{Four digit year of master data to pull in. Options include
2013- 2018. Defaults to 2018.}

\item{pooling_level}{Character string indicating the level of local revenue
pooling. Either county or state. Defaults to county.}
}
\value{
A dataframe with 17 variables where each observation is a school district.
}
\description{
This function allows you to pool local revenue for school districts at either
the county or state level to see the effects on individual districts.
}
\examples{
\donttest{state_pool <- big_borders(
           data_year = "2018",
           pooling_level = "state"
           )}
}
\seealso{
\code{\link{masterpull}}, \code{\link{master_codebook}}
}
\keyword{EdBuild}
\keyword{borders}
\keyword{pooling}
\keyword{revenue}
