# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Get the Eddington number for cycling
#'
#' Gets the \href{https://en.wikipedia.org/wiki/Arthur_Eddington#Eddington_number_for_cycling}{Eddington number for cycling}.
#' The Eddington Number for cycling, \emph{E}, is the maximum number where a
#' cyclist has ridden \emph{E} miles on \emph{E} distinct days.
#'
#' The Eddington Number for cycling is related to computing the rank of an
#' integer partition, which is the same as computing the side length of its
#' \href{https://en.wikipedia.org/wiki/Durfee_square}{Durfee square}. Another
#' relevant application of this metric is computing the Hirsch index
#' (\doi{10.1073/pnas.0507655102}) for publications.
#'
#' This is not to be confused with the
#' \href{https://en.wikipedia.org/wiki/Eddington_number}{Eddington Number in
#' astrophysics}, \eqn{N_{Edd}}, which represents the number of protons in the
#' observable universe.
#'
#' @param rides A vector of mileage, where each element represents a single
#'   day.
#'
#' @return An integer which is the Eddington cycling number for the
#'   data provided.
#'
#' @seealso \code{\link{E_cum}}, \code{\link{E_next}}, \code{\link{E_req}},
#'   \code{\link{E_sat}}
#'
#' @examples
#' # Randomly generate a set of 15 rides
#' rides <- rgamma(15, shape = 2, scale = 10)
#'
#' # View the rides sorted in decreasing order
#' setNames(sort(rides, decreasing = TRUE), seq_along(rides))
#'
#' # Get the Eddington number
#' E_num(rides)
#' @export
E_num <- function(rides) {
    .Call(`_eddington_E_num`, rides)
}

#' Calculate the cumulative Eddington number
#'
#' This function is much like \code{\link{E_num}} except it provides
#' a cumulative Eddington number over the vector rather than a single summary
#' number.
#'
#' @inheritParams E_num
#' @seealso \code{\link{E_next}}, \code{\link{E_num}}, \code{\link{E_req}},
#'   \code{\link{E_sat}}
#' @return An integer vector the same length as \code{rides}.
#' @export
E_cum <- function(rides) {
    .Call(`_eddington_E_cum`, rides)
}

#' Get the number of rides required to increment to the next Eddington number
#'
#' Get the number of rides required to increment to the next Eddington number.
#'
#' @inheritParams E_num
#' @seealso \code{\link{E_cum}}, \code{\link{E_num}}, \code{\link{E_req}},
#'   \code{\link{E_sat}}
#' @return A named list with the current Eddington number (\code{E}) and the
#'   number of rides required to increment by one (\code{req}).
#' @export
E_next <- function(rides) {
    .Call(`_eddington_E_next`, rides)
}

get_haversine_distance_ <- function(lat_1, long_1, lat_2, long_2, r) {
    .Call(`_eddington_get_haversine_distance_`, lat_1, long_1, lat_2, long_2, r)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call(`_eddington_RcppExport_registerCCallable`)
})
