% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDailyMaster.R
\name{getDailyMaster}
\alias{getDailyMaster}
\title{Retrieves daily master index}
\usage{
getDailyMaster(input.date)
}
\arguments{
\item{input.date}{in character format 'mm/dd/YYYY'.}
}
\value{
Function returns filings information in a dataframe format.
}
\description{
\code{getDailyMaster} retrieves daily master index from the U.S. SEC EDGAR server.
}
\details{
getDailyMaster function takes date as an input parameter from a user,  
and downloads master index for the date from the U.S. SEC EDGAR server 
\url{https://www.sec.gov/Archives/edgar/daily-index/}. It strips headers 
and converts this daily filing information into dataframe format.
Function creates new directory 'Daily Indexes' into working directory 
to save these downloaded daily master index files in Rda format.
}
\examples{
\dontrun{

output <- getDailyMaster('08/09/2016')
} 
}
