% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attrs.R
\name{lvl_attrs}
\alias{lvl_attrs}
\title{Setting the traits of the levels}
\usage{
lvl_attrs(
  levels = NULL,
  labels = NULL,
  prefix = "",
  suffix = "",
  sep = edibble_labels_opt("sep"),
  include_leading_zero = edibble_labels_opt("leading_zero"),
  data = NULL,
  ...
)
}
\arguments{
\item{levels}{A vector that either denotes the index number or short name of the levels.}

\item{labels}{An optional character vector that is the long name format of \code{levels}.}

\item{prefix}{The prefix of the labels.}

\item{suffix}{The suffix of the labels.}

\item{sep}{A string to add between \code{prefix} and \code{levels}.}

\item{include_leading_zero}{A logical value to indicate whether there should
be a leading zero added to level indexes. This is ignored if \code{levels} is not numeric.}

\item{data}{A list or data frame of the same size as the \code{levels}.}

\item{...}{Name-value pair denoting other level attributes. The value should be the same
length as \code{levels} or a single value.}
}
\value{
An edbl_lvls object.
}
\description{
Use this function to create a "vector" of levels. The vector is actually comprised of a
data frame with a column \code{labels} and other columns with corresponding level attribute (if any).
This data frame can be accessed with \code{lvl_data()}.
}
\examples{
lvl_attrs(c("A", "B"))
}
