% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allot.R
\name{allot_table}
\alias{allot_table}
\title{Allot treatments to units and serve table}
\usage{
allot_table(
  .edibble,
  ...,
  order = "random",
  seed = NULL,
  constrain = nesting_structure(.edibble),
  label_nested = NULL,
  fail = "error",
  .record = TRUE
)
}
\arguments{
\item{.edibble}{An edibble design which should have units, treatments and allotment defined.}

\item{...}{One-sided or two-sided formula. If the input is a one-sided formula
then the whole treatment is applied to the specified unit.}

\item{order}{A character vector signifying the apportion of treatments to units.
The value should be either "random", "systematic-fastest", "systematic-slowest",
"systematic-random-fastest", "systematic-random-slowest" or a class name corresponding to the algorithm for order_trts().
"random" allocates the treatment randomly to units based on specified allotment with restrictions
implied by unit structure.
"systematic-slowest" allocates the treatment in a systematic order to units such that the treatment level is slow in varying.
In contrast, "systematic-fastest" is fast in varying for treatment levels.
"systematic-random-fastest" and "systematic-random-slowest" allocates the treatment in a systematic order to units but
where it is not possible to divide treatments equally (as the number of units are not divisible
by the number of levels of the treatment factor), then the extras are chosen randomly.}

\item{seed}{A scalar value used to set the seed so that the result is reproducible.}

\item{constrain}{The nesting structure for units.}

\item{label_nested}{The columns to show nested labels (if available). Tidyselect compatible.}

\item{fail}{What to do when failing to convert graph to table.}

\item{.record}{Whether to record the step.}
}
\description{
This function is a short hand that combines \code{allot_trts()}, \code{assign_trts()}
and \code{serve_table()}.
}
