% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectInputDT.R
\name{selectInputDT_Server}
\alias{selectInputDT_Server}
\title{Server part to use a \code{\link[DT]{datatable}} as select input}
\usage{
selectInputDT_Server(
  id,
  label = "",
  choices,
  selected = NULL,
  multiple = FALSE
)
}
\arguments{
\item{id}{\code{character(1)} same one as used in \code{\link{selectInputDT_UI}}}

\item{label}{\code{character(1)}}

\item{choices}{\code{data.frame}}

\item{selected}{\code{data.frame} with rows available in \code{choices}.}

\item{multiple}{\code{logical}. Whether or not multiple row selection is allowed}
}
\value{
A selection of rows from the \code{data.frame} provided under choices.
}
\description{
Server part to use a \code{\link[DT]{datatable}} as select input
}
\examples{
## Only run this example in interactive R sessions
if(interactive()){
  ui <- selectInputDT_UI('id')
  data <- data.frame(id = 1:3, name = letters[1:3])
  server <- function(input,output, session){
    selected = selectInputDT_Server('id', choices = data, selected = data[1,] )
    observe({print(selected())})
  }
  shiny::shinyApp(ui, server)

}
}
\seealso{
\code{shiny::selectInput}. This function can be more convenient for selecting rows
with multiple columns.
}
\author{
Jasper Schelfhout
}
