% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooled.R
\name{sd_pooled}
\alias{sd_pooled}
\alias{mad_pooled}
\alias{cov_pooled}
\title{Pooled Indices of (Co)Deviation}
\usage{
sd_pooled(x, y = NULL, data = NULL, verbose = TRUE, ...)

mad_pooled(x, y = NULL, data = NULL, constant = 1.4826, verbose = TRUE, ...)

cov_pooled(x, y = NULL, data = NULL, verbose = TRUE, ...)
}
\arguments{
\item{x, y}{A numeric vector, or a character name of one in \code{data}.
Any missing values (\code{NA}s) are dropped from the resulting vector.
\code{x} can also be a formula (see \code{\link[stats:t.test]{stats::t.test()}}), in which case \code{y} is
ignored.}

\item{data}{An optional data frame containing the variables.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Arguments passed to or from other methods. When \code{x} is a formula,
these can be \code{subset} and \code{na.action}.}

\item{constant}{scale factor.}
}
\value{
Numeric, the pooled standard deviation. For \code{cov_pooled()} a matrix.
}
\description{
The Pooled Standard Deviation is a weighted average of standard deviations
for two or more groups, \emph{assumed to have equal variance}. It represents the
common deviation among the groups, around each of their respective means.
}
\details{
The standard version is calculated as:
\deqn{\sqrt{\frac{\sum (x_i - \bar{x})^2}{n_1 + n_2 - 2}}}{sqrt(sum(c(x - mean(x), y - mean(y))^2) / (n1 + n2 - 2))}
The robust version is calculated as:
\deqn{1.4826 \times Median(|\left\{x - Median_x,\,y - Median_y\right\}|)}{mad(c(x - median(x), y - median(y)), constant = 1.4826)}
}
\examples{
sd_pooled(mpg ~ am, data = mtcars)
mad_pooled(mtcars$mpg, factor(mtcars$am))

cov_pooled(mpg + hp + cyl ~ am, data = mtcars)

}
\seealso{
\code{\link[=cohens_d]{cohens_d()}}, \code{\link[=mahalanobis_d]{mahalanobis_d()}}
}
