% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.egonet.R
\name{onefile_to_egor}
\alias{onefile_to_egor}
\title{Import ego-centered network data from 'one file format'}
\usage{
onefile_to_egor(egos, netsize, ID.vars = list(ego = "egoID"), attr.start.col,
  attr.end.col, max.alters, aa.first.var, aa.regex = NULL, ego.vars = NULL,
  var.wise = FALSE, ...)
}
\arguments{
\item{egos}{\code{Data frame} containg ego data (egos as cases)}

\item{netsize}{\code{Vector} containing values of network size per ego.}

\item{ID.vars}{A named list containing column names of the relevant
  input columns: \describe{

\item{`ego`}{unique identifier associated with each ego, defaulting
  to `"egoID"`; has no effect if `alters.df` and `aaties.df` are
  both lists of data frames.}

\item{`alter`}{unique-within-ego identifier associated with each
  alter, defaulting to `"alterID"`; optional `aaties.df` are not
  provided.}

\item{`source`}{if `aaties.df` is provided, the column given the
  alter identifier of the origin of a relation.}

\item{`target`}{if `aaties.df` is provided, the column given the
  alter identifier of the destination of a relation.}

}}

\item{attr.start.col}{Index or name of the first colum containing alter attributes.}

\item{attr.end.col}{Index or name of the last colum containing alter attributes.}

\item{max.alters}{Maximum number of alters.}

\item{aa.first.var}{First column containing alter-alter relations/ edges.}

\item{aa.regex}{A Perl regular expression with name capture,
intended to be run on column names and capturing via named
capture the following regex groups: `"attr"`, `"src"`, and
`"tgt"`, representing the edge attribute being captured, the
source (or the first alter identified), and the target (or the
second alter identified) of the edge, respectively. See [`regex`]
for more information.}

\item{ego.vars}{A \code{data.frame} of alter attributes in the wide format.}

\item{var.wise}{Logical value indicatin if the alter attributes are sorted variable wise (defaults to FALSE).}

\item{...}{additional arguments to \code{\link[=egor]{egor()}}.}
}
\value{
A \code{list} of six objects - the **egoR** object: (1) egos.df: \code{dataframe} of all
egos and their attributes; (2) alters.df: \code{dataframe} of all alters;
(3) alters.list: \code{list} of \code{dataframes} of all alters per ego;
(4) edges: \code{list} of \code{dataframes} with edge lists per network; (5)
graphs: \code{list} of igraph objects; (6) results: a result \code{dataframe},
pre-populated with the network size of each network
}
\description{
This function imports ego-centered network data, stored in a single file, providing
ego, alter and edge data. This data format is used by the Allbus 2010 (GESIS)
and similar social surveys.
}
\references{
Muller, C., Wellman, B., & Marin, A. (1999). How to Use SPSS to
Study Ego-Centered Networks. Bulletin de Methodologie Sociologique,
64(1), 83-100.
}
\keyword{import}
