% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egor.R
\name{egor}
\alias{egor}
\alias{as.egor}
\alias{as.egor.nested_egor}
\title{egor - a data class for ego-centered network data.}
\usage{
egor(
  alters,
  egos = NULL,
  aaties = NULL,
  ID.vars = list(ego = "egoID", alter = "alterID", source = "Source", target =
    "Target"),
  ego_design = NULL,
  alter_design = list(max = Inf)
)

as.egor(x, ...)

\method{as.egor}{nested_egor}(
  x,
  ID.vars = list(ego = ".egoID", alter = ".alterID", source = ".Source", target =
    ".Target"),
  ...
)
}
\arguments{
\item{alters}{either a \code{data.frame} containing the alters
(whose nominator is identified by the column specified by \code{egoID}
or a list of data frames with the same columns, one for each ego,
with empty data frames or \code{NULL}s corresponding to egos with no
nominees.}

\item{egos}{\code{data.frame} containing the egos.}

\item{aaties}{\code{data.frame} containing the alter-alter
relations in the style of an edge list, or a list of data frames
similar to \code{alters.df}.}

\item{ID.vars}{A named list containing column names of the relevant
input columns: \describe{

\item{\code{ego}}{unique identifier associated with each ego, defaulting
to \code{"egoID"}; has no effect if \code{alters.df} and \code{aaties.df} are
both lists of data frames.}

\item{\code{alter}}{unique-within-ego identifier associated with each
alter, defaulting to \code{"alterID"}; optional \code{aaties.df} are not
provided.}

\item{\code{source}}{if \code{aaties.df} is provided, the column given the
alter identifier of the origin of a relation.}

\item{\code{target}}{if \code{aaties.df} is provided, the column given the
alter identifier of the destination of a relation.}

}}

\item{ego_design}{A \code{\link{list}} of arguments to
\code{\link[srvyr:as_survey_design]{srvyr::as_survey_design()}} specifying the sampling design for
the egos. If formulas, they can refer to columns of
\code{egos.df}. \code{NULL} means that no design is set.}

\item{alter_design}{A \code{\link{list}} of arguments specifying nomination
information. Currently, the following elements are supported:
\describe{\item{\code{"max"}}{Maximum number of alters that an
ego can nominate.}}}

\item{x}{an object to be coerced to \code{\link{egor}}.}

\item{...}{arguments to be passed to methods}
}
\value{
Returns an \code{\link{egor}} object. An \code{\link{egor}} object is a \code{\link{tibble}} whose
top-level columns store the ego attributes, and which has two
special nested columns: \code{.alts}, containing, for each row (ego) a
table of that ego's alter attributes and \code{.aaties}, a table
containing that ego's alter--alter ties, if observed.

If alter-alter ties are observed, \code{.alts} also has a column
\code{.altID} giving a unique (within each ego) ID of the alter, by
which the alter can be identified in the \code{.aaties} table for that
ego. \code{.aaties}, in turn, has columns \code{.srcID} and \code{.tgtID} that
contain the source and the target of the alter-alter relation.

In addition, \code{egor} has two attributes: \code{ego_design}, containing an
object returned by \code{\link[srvyr:as_survey_design]{srvyr::as_survey_design()}} specifying the sampling
design by which the egos were selected and \code{alter_design}, a
\code{\link{list}} containing specification of how the alters were
nominated. See the argument above for currently implemented
settings.
}
\description{
The function \code{\link[=egor]{egor()}} is used to create an egor object from
ego-centered network data.
}
\details{
If parameters \code{alters.df}, \code{egos.df}, and \code{aaties.df} are
data frames, they need to share a common ego ID variable, with
corresponding values. If \code{alters.df} and \code{aaties.df} are lists of
data frames, \code{egoID} is ignored and they are matched positionally
with the rows of \code{egos.df}. Of the three parameters only
\code{alters.df} is necessary to create an \code{egor} object, and
\code{egos.df} and \code{aaties.df} are optional.
}
\section{Methods (by generic)}{
\itemize{
\item \code{as.egor}: Can convert (legacy) \code{nested_egor} object to \code{egor} object.
}}

\note{
Column names \code{.alts}, \code{.aaties}, and \code{.egoRow} are reserved
for internal use of \code{egor} and should not be used to store
persistent data. Other \code{.}-led column names may be reserved in
the future.
}
\examples{
data("egos32")
data("alters32")
data("aaties32") 

egor(alters32, 
     egos32, 
     aaties32,
     ID.vars = list(ego = ".EGOID", 
                    alter = ".ALTID", 
                    source = ".SRCID",
                    target =  ".TGTID"))
}
\keyword{analysis}
\keyword{ego-centered}
\keyword{network}
