# ehymet

<!-- badges: start -->
[![Build\_Status](https://github.com/bpulidob/ehymet/actions/workflows/build.yml/badge.svg)](https://github.com/bpulidob/ehymet/actions/workflows/build.yml)
[![DOI](https://img.shields.io/badge/doi-10.1007%2Fs11222--023--10213--7-informational.svg)](https://link.springer.com/article/10.1007/s11222-023-10213-7)
[![DOI](https://img.shields.io/badge/doi-10.48550%2FarXiv.2307.16720-%23B31B1B.svg)](https://arxiv.org/abs/2307.16720)
<!-- badges: end -->

The **ehymet** (Methodologies for functional data based on the epigraph
and hypograph indices) package define the epigraph, the hypograph and
their modified versions for functional datasets in one and multiple
dimensions. These indices allow to transform a functional dataset into a
multivariate one, where usual clustering techniques can be applied. This
package implements EHyClus method for clustering functional data in one
or multiple dimension.

## Related Papers:

- Belén Pulido, Alba M. Franco-Pereira, Rosa E. Lillo (2023). “A fast
  epigraph and hypograph-based approach for clustering functional data.”
  *Statistics and Computing*, **33**, 36. doi:
  [10.1007/s11222-023-10213-7](https://doi.org/10.1007/s11222-023-10213-7)

- Belén Pulido, Alba M. Franco-Pereira, Rosa E. Lillo (2023). “The
  epigraph and the hypograph indices as useful tools for clustering
  multivariate functional data.” doi:
  [10.48550/arXiv.2307.16720](https://doi.org/10.48550/arXiv.2307.16720)

## Installation

You can install the development version of **ehymet** from github using the
[remotes](https://cran.r-project.org/package=remotes) package:

```r
# install.packages("remotes")
remotes::install_github("bpulidob/ehymet")
```
