% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ga_geo}
\alias{ga_geo}
\title{Voter file information that has been geocoded}
\format{
A data frame with 12 rows and 25 columns
\describe{
\item{county_code}{Unique identifier for counties in the state of Georgia}
\item{county_name}{A list of the county name matching the county_code}
\item{registration_number}{Unique identifier for registered voter identification}
\item{voter_status}{The registration status of the voter}
\item{last_name}{The last name of the voter}
\item{first_name}{The first name of the voter}
\item{str_num}{The street number of the voter address}
\item{str_name}{The name of the street of the voter address}
\item{str_suffix}{The suufix of the street that is commonly directional}
\item{city}{The city of the voter address}
\item{state}{The state of the voter address}
\item{zipcode}{The 5 or 9 digit zipcode of the voter address}
\item{street_address}{The street number and street name, concatenated}
\item{final_address}{The street_address, city, state, and zipcode
concatenated}
\item{cxy_address}{The address generated and predicted by the
US Census Geocoder}
\item{cxy_status}{The US Census Geocoder flag for whether an addresses
was matched in the US Census Geocoder}
\item{cxy_quality}{The determinant of whether the addresses matched exctly}
\item{cxy_matched_address}{The address used to compare with the voter
address inputted into the Geocoder API to determine whether a match
has occurred}
\item{cxy_tiger_line_id}{unique identifier from the Tiger line database
that captures geographic aras of interests like roads, railroads,
rivers, etc.}
\item{cxy_tiger_side}{a directional identifier in the Tiger Line database}
\item{STATEFP10}{the FIPS code for the state geograhic level}
\item{COUNTYFP10}{the FIPS code for the county geographic level}
\item{TRACTCE10}{the FIPS code for the tract geographic level}
\item{BLOCKCE10}{the FIPS code for the block geographic level}
\item{geometry}{latitude and longitude coordinates}
}
}
\usage{
data(ga_geo)
}
\description{
This dataset contains results from geocoding voter addresses using
the U.S. Census Bureau. The geocoded voter file has 12 observations
and 25 variables that include a geometry of latitude and longitude
points and fips code values for state, county, tract, and block
geographies.
}
\keyword{datasets}
