% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{mapping}
\alias{mapping}
\alias{mapping_create}
\alias{mapping_get}
\alias{field_mapping_get}
\alias{type_exists}
\title{Mapping management}
\usage{
mapping_create(index, type, body, update_all_types = FALSE, ...)

mapping_get(index = NULL, type = NULL, ...)

field_mapping_get(index = NULL, type = NULL, field,
  include_defaults = FALSE, ...)

type_exists(index, type, ...)
}
\arguments{
\item{index}{(character) An index}

\item{type}{(character) A document type}

\item{body}{(list) Either a list or json, representing the query.}

\item{update_all_types}{(logical) update all types. default: \code{FALSE}.
This parameter is deprecated in ES v6.3.0 and higher, see
https://github.com/elastic/elasticsearch/pull/28284}

\item{...}{Curl options passed on to \code{\link[httr:HEAD]{httr::HEAD()}} or other
http verbs}

\item{field}{(character) One or more field names}

\item{include_defaults}{(logical) Whether to return default values}
}
\description{
Mapping management
}
\details{
Find documentation for each function at:
\itemize{
\item \code{mapping_create} -
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-put-mapping.html}
\item \code{type_exists} -
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-types-exists.html}
\item \code{mapping_delete} - FUNCTION DEFUNCT - instead of deleting mapping, delete
index and recreate index with new mapping
\item \code{mapping_get} -
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-get-mapping.html}
\item \code{field_mapping_get} -
\url{https://www.elastic.co/guide/en/elasticsearch/reference/current/indices-get-field-mapping.html}
}
}
\examples{
\dontrun{
# Used to check if a type/types exists in an index/indices
type_exists(index = "plos", type = "article")
type_exists(index = "plos", type = "articles")
type_exists(index = "shakespeare", type = "line")

# The put mapping API allows to register specific mapping definition for a specific type.
## a good mapping body
body <- list(citation = list(properties = list(
 journal = list(type="text"),
 year = list(type="long")
)))
if (!index_exists("plos")) index_create("plos")
mapping_create(index = "plos", type = "citation", body=body)

### or as json
body <- '{
  "citation": {
    "properties": {
      "journal": { "type": "text" },
      "year": { "type": "long" }
}}}'
mapping_create(index = "plos", type = "citation", body=body)
mapping_get("plos", "citation")

## A bad mapping body
body <- list(things = list(properties = list(
  journal = list("text")
)))
# mapping_create(index = "plos", type = "things", body=body)

# Get mappings
mapping_get('_all')
mapping_get(index = "plos")
mapping_get(index = c("shakespeare","plos"))
mapping_get(index = "shakespeare", type = "act")
mapping_get(index = "shakespeare", type = c("act","line"))

# Get field mappings
plosdat <- system.file("examples", "plos_data.json", package = "elastic")
invisible(docs_bulk(plosdat))
field_mapping_get(index = "_all", type=c('article', 'line'), field = "text")
field_mapping_get(index = "plos", type = "article", field = "title")
field_mapping_get(index = "plos", type = "article", field = "*")
field_mapping_get(index = "plos", type = "article", field = "title", include_defaults = TRUE)
field_mapping_get(type = c("article","record"), field = c("title","class"))
field_mapping_get(type = "a*", field = "t*")

# Create geospatial mapping
if (index_exists("gbifgeopoint")) index_delete("gbifgeopoint")
file <- system.file("examples", "gbif_geopoint.json", package = "elastic")
index_create("gbifgeopoint")
body <- '{
 "properties" : {
   "location" : { "type" : "geo_point" }
 }
}'
mapping_create("gbifgeopoint", "record", body = body)
invisible(docs_bulk(file))

# update_all_fields, see also ?fielddata
if (es_ver() < 603) {
 mapping_create("shakespeare", "record", update_all_types=TRUE, body = '{
   "properties": {
     "speaker": { 
       "type":     "text",
       "fielddata": true
     }
   }
 }')
} else {
 index_create('brownchair')
 mapping_create('brownchair', 'brown', body = '{
   "properties": {
     "foo": { 
       "type":     "text",
       "fielddata": true
     }
   }
 }')
}

}
}
