% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/social_choice.R
\name{social_choice}
\alias{social_choice}
\title{Election Social Choice Functions}
\usage{
social_choice(
  ballots,
  sc_function = c("plurality", "irv", "stv"),
  n_winners = 1,
  ...
)
}
\arguments{
\item{ballots}{A `prefio::preferences` object containing the ballots cast in the election.}

\item{sc_function}{One of "plurality", "irv" or "stv", corresponding to the social choice
function you wish to evaluate.}

\item{n_winners}{Refers to the number of seats available when `sc_function` is "stv".}

\item{...}{Unused.}
}
\value{
The output depends on the chosen `sc_function`:
\describe{
   \item{"plurality"}{A character vector with the candidate(s) who received
                      the most votes.}
   \item{"irv"}{A named `list` with two objects. First, "elimination_order"
                is a vector with each eliminated candidate in the order of
                elimination. Second, "winners" is the vector containing the
                winning candidate(s).}
   \item{"stv"}{Not yet implemented.}
}
}
\description{
Compute election outcomes on ranked ballots with a variety of social choice
functions.
}
\keyword{choice}
\keyword{election}
\keyword{irv}
\keyword{plurality}
\keyword{social}
\keyword{stv}
