% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personal_finances.R
\name{personal_finances}
\alias{personal_finances}
\title{Download data on federal candidates' personal financial disclosures}
\usage{
personal_finances(
  year,
  uf = "all",
  br_archive = FALSE,
  encoding = "latin1",
  temp = TRUE,
  readme_pdf = FALSE
)
}
\arguments{
\item{year}{Election year. For this function, only the years 2006, 2010, 2014, 2018 and 2022 are available.}

\item{uf}{Federation Unit acronym (\code{character vector}).}

\item{br_archive}{In the TSE's data repository, some results can be obtained for the whole country by loading a single
within a single file by setting this argument to \code{TRUE} (may not work in for some elections and, in 
other, it recoverns only electoral data for presidential elections, absent in other files).}

\item{encoding}{Data original encoding (defaults to 'Latin-1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). If \code{TRUE}, keep the temporary compressed file for future use (recommended)}

\item{readme_pdf}{original readme}
}
\value{
\code{personal_finances()} returns a \code{data.frame}.
}
\description{
\code{personal_finances()} downloads and aggregates the data on federal candidates' personal financial disclosures. The function returns a \code{data.frame} where each observation corresponds to a candidate's property.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2000, some information may be incomplete.
}
\examples{
\dontrun{
df <- personal_finances(2006)
}
}
