% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disjoint.R
\name{disjoint}
\alias{disjoint}
\title{Multiple scaling -- the disjoint way}
\usage{
disjoint(
  df,
  mrit_min = 0.3,
  negative_too = FALSE,
  sclvals = NULL,
  use = "pairwise.complete.obs"
)
}
\arguments{
\item{df}{a data frame (with more than two items and unique, non-\code{NA}
column names).}

\item{mrit_min}{a numeric constant of length 1 to specify the marginal
corrected item-total correlation. Its value is in the range of 0-1. The
default is set to \code{.3}.}

\item{negative_too}{a logical constant indicating whether reversed items are
included in the analysis. The default is set to \code{FALSE}.}

\item{sclvals}{a numeric vector of length 2 indicating the start- and
endpoint of a scale. Use something like \code{c(min,max)}.}

\item{use}{an optional string to specify how missing values enter the
analysis. See \code{use} in \code{\link[stats]{cor}} for details. The
default is set to \code{pairwise.complete.obs}.}
}
\value{
A multiple scaled data frame (\code{msdf}).
}
\description{
\code{disjoint()} returns a multiple, disjointedly scaled
  version of the specified data frame. This so called \code{msdf} sets up the
  building block for further analysis with \code{overlap()} (type
  \code{?overlap}).
}
\details{
\code{use} clarifies how to set up a correlation matrix in the
  presence of missing values. In a typical scaling process this happens at
  least twice. First, when determining the core items (the two items in the
  correlation matrix with the highest linear relationship). Second, when an
  item is proposed for an emerging scale.

  Note that \code{disjoint()} uses \code{\link[stats]{cor}}'s default method
  \code{pearson}.
}
\examples{
# Use only positive correlations
disjoint(mtcars, mrit_min = .4)

# Include negative correlations
disjoint(mtcars, mrit_min = .4, negative_too = TRUE, sclvals = c(1,7))

# Change the treatment of missing values
disjoint(mtcars, mrit_min = .4, use = "all.obs")
}
\references{
Müller-Schneider, T. (2001). Multiple Skalierung nach dem
  Kristallisationsprinzip / Multiple Scaling According to the Principle of
  Crystallization. Zeitschrift für Soziologie, 30(4), 305-315.
  https://doi.org/10.1515/zfsoz-2001-0404
}
