% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.msdf.R
\name{print.msdf}
\alias{print.msdf}
\title{Print method for a multiple scaled data frame}
\usage{
\method{print}{msdf}(x, digits = 2, use = "pairwise.complete.obs", ...)
}
\arguments{
\item{x}{a multiple scaled data frame (built with either
\code{disjoint()} or \code{overlap()}).}

\item{digits}{an integer constant to determine the number of printed digits.
See \code{digits} in \code{\link[base]{options}} for details.}

\item{use}{an optional string to specify how missing values enter the
analysis. See \code{use} in \code{\link[stats]{cor}} for details. The
default is set to \code{pairwise.complete.obs}.}

\item{...}{Additional arguments to the method which will be ignored.}
}
\value{
A list of summary statistics: the marginal corrected item-total
  correlation (\code{mrit}), Cronbach's alpha (\code{alpha}), and the average
  correlation (\code{rbar}).
}
\description{
The print method for a multiple scaled data frame. It summarizes
  the \code{msdf} using values of classical test theory. Note that every line
  in the output tags a new stage in the development process of each gradually
  emerging scale.
}
\details{
\code{use} clarifies how to set up a correlation matrix in the
  presence of missing values. In a typical scaling process this happens at
  least twice. First, when determining the core items (the two items in the
  correlation matrix with the highest linear relationship). Second, when an
  item is proposed for an emerging scale.
}
\references{
Müller-Schneider, T. (2001). Multiple Skalierung nach dem
  Kristallisationsprinzip / Multiple Scaling According to the Principle of
  Crystallization. Zeitschrift für Soziologie, 30(4), 305-315.
  https://doi.org/10.1515/zfsoz-2001-0404
}
