% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe.R
\name{safe_median}
\alias{safe_median}
\alias{safe_median.numeric}
\title{Safe version of median}
\usage{
safe_median(x, ...)

\method{safe_median}{numeric}(x, ..., na.rm = TRUE)
}
\arguments{
\item{x}{Numeric vector}

\item{...}{Additional arguments passed on to methods.}

\item{na.rm}{For numeric method, should missing values be removed?}
}
\description{
\code{safe_median()} works \code{\link[stats:median]{stats::median()}} but warns if some elements of \code{...}
are never used.
}
\examples{
x <- c(1:10, NA)
safe_median(x, na.rm = TRUE)
median(x, na.rm = TRUE)

try(median(x, na.mr = TRUE))
try(safe_median(x, na.mr = TRUE))

try(median(1, 2, 3))
try(safe_median(1, 2, 3))
}
