% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{get_fitness_from_models_dir}
\alias{get_fitness_from_models_dir}
\title{Load the models fitness scores}
\usage{
get_fitness_from_models_dir(models.dir)
}
\arguments{
\item{models.dir}{string. A dir with \emph{.gitsbe} files/models}
}
\value{
a numeric vector with elements the fitness scores and the names of the
models included in the \emph{names} attribute.
}
\description{
Use this function to merge the fitness scores from all models into a single
vector (the fitness score is a value between 0 and 1 and denotes how close
was the model fitted to one or more training data observations). Each model's
fitness value is loaded from the respective \emph{.gitsbe} file that can be
found inside the given \code{models.dir} directory (other kind of files are
discarded).
}
\examples{

models.dir = system.file("extdata", "models", package = "emba", mustWork = TRUE)
models.fitness = get_fitness_from_models_dir(models.dir)

}
