% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme.R
\name{step_lencode_mixed}
\alias{step_lencode_mixed}
\title{Supervised Factor Conversions into Linear Functions using Bayesian Likelihood Encodings}
\usage{
step_lencode_mixed(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  outcome = NULL,
  options = list(verbose = 0),
  mapping = NULL,
  skip = FALSE,
  id = rand_id("lencode_mixed")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables.
For \code{step_lencode_mixed}, this indicates the variables to be encoded
into a numeric format. See \code{\link[recipes:selections]{recipes::selections()}} for more details. For
the \code{tidy} method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{outcome}{A call to \code{vars} to specify which variable is
used as the outcome in the generalized linear model. Only
numeric and two-level factors are currently supported.}

\item{options}{A list of options to pass to \code{\link[lme4:lmer]{lme4::lmer()}} or
\code{\link[lme4:glmer]{lme4::glmer()}}.}

\item{mapping}{A list of tibble results that define the
encoding. This is \code{NULL} until the step is trained by
\code{\link[recipes:prep]{recipes::prep()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any). For the \code{tidy}
method, a tibble with columns \code{terms} (the selectors or
variables for encoding), \code{level} (the factor levels), and
\code{value} (the encodings).
}
\description{
\code{step_lencode_mixed} creates a \emph{specification} of a recipe step that
will convert a nominal (i.e. factor) predictor into a single set of
scores derived from a generalized linear mixed model.
}
\details{
For each factor predictor, a generalized linear model
is fit to the outcome and the coefficients are returned as the
encoding. These coefficients are on the linear predictor scale
so, for factor outcomes, they are in log-odds units. The
coefficients are created using a no intercept model and, when
two factor outcomes are used, the log-odds reflect the event of
interest being the \emph{first} level of the factor.

For novel levels, a slightly timmed average of the coefficients
is returned.

A hierarchical generalized linear model is fit using
\code{\link[lme4:lmer]{lme4::lmer()}} or \code{\link[lme4:glmer]{lme4::glmer()}}, depending
on the nature of the outcome, and no intercept via\preformatted{  lmer(outcome ~ 1 + (1 | predictor), data = data, ...)
}

where the \code{...} include the \code{family} argument (automatically
set by the step) as well as any arguments given to the \code{options}
argument to the step. Relevant options include \code{control} and
others.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns
\code{terms} (the selectors or variables selected), \code{value} and \code{component} is
returned.
}

\examples{
library(recipes)
library(dplyr)
library(modeldata)

data(grants)

set.seed(1)
grants_other <- sample_n(grants_other, 500)
\donttest{
reencoded <- recipe(class ~ sponsor_code, data = grants_other) \%>\%
  step_lencode_mixed(sponsor_code, outcome = vars(class))
}
}
\references{
Micci-Barreca D (2001) "A preprocessing scheme for
high-cardinality categorical attributes in classification and
prediction problems," ACM SIGKDD Explorations Newsletter, 3(1),
27-32.

Zumel N and Mount J (2017) "vtreat: a data.frame Processor for
Predictive Modeling," arXiv:1611.09477
}
\concept{preprocessing encoding}
\keyword{datagen}
