% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.tsd.R
\name{predict.tsd}
\alias{predict.tsd}
\title{Estimate sex ratio according to constant incubation temperature}
\usage{
\method{predict}{tsd}(
  object,
  temperatures = NULL,
  durations = NULL,
  SD.temperatures = NULL,
  SD.durations = NULL,
  resultmcmc = NULL,
  chain = 1,
  replicate.CI = 10000,
  probs = c(0.025, 0.5, 0.975),
  ...
)
}
\arguments{
\item{object}{A result file generated by tsd}

\item{temperatures}{A vector of temperatures}

\item{durations}{A vector of durations}

\item{SD.temperatures}{SD of temperatures}

\item{SD.durations}{SD of durations}

\item{resultmcmc}{A result of tsd_MHmcmc()}

\item{chain}{What chain to be used is resultmcmc is provided}

\item{replicate.CI}{Number of replicates to estimate CI}

\item{probs}{The quantiles to be returned, default=c(0.025, 0.5, 0.975)}

\item{...}{Not used}
}
\value{
A data.frame with informations about sex-ratio
}
\description{
Estimate sex ratio according to constant incubation temperature\cr
The data.frame has the temperatures or durations in columns and the quantiles in rows.\cr
Note that incubation duration is a very bad proxy for sex ratio. See Georges,
A., Limpus, C. J. & Stoutjesdijk, R. 1994. Hatchling sex in the marine turtle
\emph{Caretta caretta} is determined by proportion of development at a temperature,
not daily duration of exposure. J. Exp. Zool., 270, 432-444.\cr
If replicate.CI is 0 or NULL, point estimate for maximum likelihood is returned.
}
\details{
predict.tsd Estimate sex ratio according to constant incubation temperature
}
\examples{
\dontrun{
library(embryogrowth)
m <- c(10, 14, 7, 4, 3, 0, 0)
f <- c(0, 1, 2, 4, 15, 10, 13)
t <- c(25, 26, 27, 28, 29, 30, 31)
result <- tsd(males=m, females=f, temperatures=t)
plot(result)
predict(result, temperatures=c(25, 31), replicate.CI = 10000)
predict(result, temperatures=c(25, 31), SD.temperatures = c(1, 2), replicate.CI = 10000)
d <- c(72, 70, 65, 63, 62, 60, 59)
result <- tsd(males=m, females=f, durations=d)
predict(result, durations=c(67, 68), replicate.CI = 10000)
}
}
\seealso{
Other Functions for temperature-dependent sex determination: 
\code{\link{DatabaseTSD}},
\code{\link{DatabaseTSD.version}()},
\code{\link{P_TRT}()},
\code{\link{ROSIE}},
\code{\link{ROSIE.version}()},
\code{\link{TSP.list}},
\code{\link{plot.tsd}()},
\code{\link{stages}},
\code{\link{tsd}()},
\code{\link{tsd_MHmcmc}()},
\code{\link{tsd_MHmcmc_p}()}
}
\author{
Marc Girondot
}
\concept{Functions for temperature-dependent sex determination}
