% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hspec.R
\docType{class}
\name{hspec-class}
\alias{hspec-class}
\title{An S4 class to represent an exponential marked Hawkes model}
\description{
This class represents a specification of a marked Hawkes model with exponential kernel.
The intensity of the ground process is defined by:
\deqn{\lambda(t) = \mu + \int ( \alpha + \Psi ) * exp( -\beta (t-u)) d N(t).}
For more details, please see the vignettes.
}
\details{
\eqn{\mu} is base intensity.
This is generally a constant vector but can be extended to stochastic processes.
Currently, piecewise constant mu is also possible. mu is left continous.

\eqn{\alpha} is a constant matrix which represents impacts on intensities after events.
It is represented by slot \code{mu}.

\eqn{\Psi} is for non-constant parts of the impact.
It may depend on any information generated by \eqn{N}, \eqn{\lambda}, \eqn{k} and so on.
It is represented by slot \code{impact}.

\eqn{\beta} is a constant matrix for exponential decay rates.
It is represetned by slot \code{beta}.

\eqn{k} is mark and represented by slot \code{rmark}.

\code{mu}, \code{alpha} and \code{beta} are required slots for every exponential Hawkes model.
\code{rmark} and \code{impact} are additional slots.
}
\section{Slots}{

\describe{
\item{\code{mu}}{numeric value or matrix or function, if numeric, automatically converted to matrix}

\item{\code{alpha}}{numeric value or matrix or function, if numeric, automatically converted to matrix, exciting term}

\item{\code{beta}}{numeric value or matrix or function, if numeric,, automatically converted to matrix, exponential decay}

\item{\code{dimens}}{dimension of the model}

\item{\code{rmark}}{a function that generates mark for counting process, for simulation}

\item{\code{dmark}}{a density function for mark, for estimation}

\item{\code{impact}}{a function that describe the after impact of mark to lambda}

\item{\code{type_col_map}}{used for multiple kernel}
}}

\examples{
MU <- matrix(c(0.2), nrow = 2)
ALPHA <- matrix(c(0.75, 0.92, 0.92, 0.75), nrow = 2, byrow=TRUE)
BETA <- matrix(c(2.25, 2.25, 2.25, 2.25), nrow = 2, byrow=TRUE)
mhspec2 <- new("hspec", mu=MU, alpha=ALPHA, beta=BETA)

}
