% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape-result.r
\name{get_importance}
\alias{get_importance}
\title{Feature (variable) importance of a fitted model}
\usage{
get_importance(object, format, ...)
}
\arguments{
\item{object}{Fitted model.}

\item{format}{Table format of the output. See
\url{http://en.wikipedia.org/wiki/Wide_and_narrow_data} for more info.}

\item{...}{Sent on to the procedure's feature importance scoring function.}
}
\value{
A vector of length p or an p-x-c matrix of feature importance
  scores where p is the number of descriptors and c is the number of classes.
}
\description{
Note that different methods calculates feature importance in different
ways and that they are not directly comparable.
}
\details{
When extending the \pkg{emil} framework with your own method, the importance
function should return a data frame where one column is called "feature" and
the remaining columns are named after the classes.
}
\examples{
procedure <- modeling_procedure("pamr")
model <- fit("pamr", x=iris[-5], y=iris$Species)
get_importance(model)

cv <- resample("crossvalidation", iris$Species, nrepeat=2, nfold=3)
result <- evaluate("pamr", iris[-5], iris$Species, resample=cv,
                   .save=c(importance=TRUE))
get_importance(result)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}
}

