% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.R
\name{rbind.emmGrid}
\alias{rbind.emmGrid}
\alias{+.emmGrid}
\alias{[.emmGrid}
\title{Combine or subset \code{emmGrid} objects}
\usage{
\method{rbind}{emmGrid}(..., deparse.level = 1, adjust = "bonferroni")

\method{+}{emmGrid}(e1, e2)

\method{[}{emmGrid}(x, i, adjust, drop.levels = TRUE, ...)
}
\arguments{
\item{...}{In \code{rbind}, object(s) of class \code{emmGrid}. 
In \code{"["}, it is ignored.}

\item{deparse.level}{(required but not used)}

\item{adjust}{Character value passed to \code{\link{update.emmGrid}}}

\item{e1}{An \code{emmGrid} object}

\item{e2}{Another \code{emmGrid} object}

\item{x}{An \code{emmGrid} object to be subsetted}

\item{i}{Integer vector of indexes}

\item{drop.levels}{Logical value. If \code{TRUE}, the \code{"levels"} slot in
the returned object is updated to hold only the predictor levels that actually occur}
}
\value{
A revised object opf class \code{emmGrid}

The result of \code{e1 + e2} is the same as \code{rbind(e1, e2)}
}
\description{
These functions provide methods for \code{\link[base:cbind]{rbind}} and
\code{\link[base:Extract]{[}} that may be used to combine \code{emmGrid} objects
together, or to extract a subset of cases. The primary reason for 
doing this would be to obtain multiplicity-adjusted results for smaller
or larger families of tests or confidence intervals.
}
\note{
\code{rbind} throws an error if there are incompatibilities in
  the objects' coefficients, covariance structures, etc. But they 
  are allowed to have different factors; a missing level \code{'.'}
  is added to factors as needed.
}
\examples{
warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)
warp.rg <- ref_grid(warp.lm)

# Show only 3 of the 6 cases
summary(warp.rg[c(2,4,5)])

# Do all pairwise comparisons within rows or within columns, 
# all considered as one faily of tests:
w.t <- pairs(emmeans(warp.rg, ~ wool | tension))
t.w <- pairs(emmeans(warp.rg, ~ tension | wool))
rbind(w.t, t.w, adjust = "mvt")
update(w.t + t.w, adjust = "fdr")  ## same as abve except for adjustment

}
