% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emm-contr.R
\name{contrast-methods}
\alias{contrast-methods}
\alias{pairwise.emmc}
\alias{emmc-functions}
\alias{revpairwise.emmc}
\alias{tukey.emmc}
\alias{poly.emmc}
\alias{trt.vs.ctrl.emmc}
\alias{trt.vs.ctrl1.emmc}
\alias{trt.vs.ctrlk.emmc}
\alias{dunnett.emmc}
\alias{eff.emmc}
\alias{del.eff.emmc}
\alias{consec.emmc}
\alias{mean_chg.emmc}
\title{Contrast families}
\usage{
pairwise.emmc(levs, exclude = integer(0), include, ...)

revpairwise.emmc(levs, exclude = integer(0), include, ...)

tukey.emmc(levs, reverse = FALSE, ...)

poly.emmc(levs, max.degree = min(6, k - 1), ...)

trt.vs.ctrl.emmc(levs, ref = 1, reverse = FALSE,
  exclude = integer(0), include, ...)

trt.vs.ctrl1.emmc(levs, ref = 1, ...)

trt.vs.ctrlk.emmc(levs, ref = length(levs), ...)

dunnett.emmc(levs, ref = 1, ...)

eff.emmc(levs, exclude = integer(0), include, ...)

del.eff.emmc(levs, exclude = integer(0), include, ...)

consec.emmc(levs, reverse = FALSE, exclude = integer(0), include, ...)

mean_chg.emmc(levs, reverse = FALSE, exclude = integer(0), include,
  ...)
}
\arguments{
\item{levs}{Vector of factor levels}

\item{exclude}{integer vector of indices, or character vector of levels to exclude
from consideration. These levels will receive weight 0 in all contrasts.
Character levels must exactly match elements of \code{levs}.}

\item{include}{integer or character vector of levels to include (the
complement of \code{exclude}). An error will result if the user specifies
both \code{exclude} and \code{include}.}

\item{...}{Additional arguments, passed to related methods as appropriate}

\item{reverse}{Logical value to determine the direction of comparisons}

\item{max.degree}{Integer specifying the maximum degree of polynomial contrasts}

\item{ref}{Integer(s) or character(s) specifying which level(s) to use 
as the reference. Character values must exactly match elements of \code{levs}.}
}
\value{
A data.frame, each column containing contrast coefficients for levs.
  The "desc" attribute is used to label the results in emmeans, and the
  "adjust" attribute gives the default adjustment method for multiplicity.
}
\description{
Functions with an extension of \code{.emmc} provide for named contrast 
families. One of the standard ones documented here may be used, or 
the user may write such a function.
}
\details{
Each standard contrast family has a default multiple-testing adjustment as
noted below. These adjustments are often only approximate; for a more
exacting adjustment, use the interfaces provided to
\code{glht} in the \pkg{multcomp} package.

\code{pairwise.emmc}, \code{revpairwise.emmc}, and \code{tukey.emmc} generate
contrasts for all pairwise comparisons among estimated marginal means at the
levels in levs. The distinction is in which direction they are subtracted.
For factor levels A, B, C, D, \code{pairwise.emmc} generates the comparisons
A-B, A-C, A-D, B-C, B-D, and C-D, whereas \code{revpairwise.emmc} generates
B-A, C-A, C-B, D-A, D-B, and D-C. \code{tukey.emmc} invokes
\code{pairwise.emmc} or \code{revpairwise.emmc} depending on \code{reverse}. 
The default multiplicity adjustment method is \code{"tukey"}, which is only
approximate when the standard errors differ.

\code{poly.emmc} generates orthogonal polynomial contrasts, assuming 
equally-spaced factor levels. These are derived from the
\code{\link[stats]{poly}} function, but an \emph{ad hoc} algorithm is used to
scale them to integer coefficients that are (usually) the same as in
published tables of orthogonal polynomial contrasts. The default multiplicity
adjustment method is \code{"none"}.

\code{trt.vs.ctrl.emmc} and its relatives generate contrasts for comparing
one level (or the average over specified levels) with each of the other
levels. The argument \code{ref} should be the index(es) (not the labels) of
the reference level(s). \code{trt.vs.ctrl1.emmc} is the same as
\code{trt.vs.ctrl.emmc} with a reference value of 1, and
\code{trt.vs.ctrlk.emmc} is the same as \code{trt.vs.ctrl} with a reference
value of \code{length(levs)}. \code{dunnett.emmc} is the same as
\code{trt.vs.ctrl}. The default multiplicity adjustment method is
\code{"dunnettx"}, a close approximation to the Dunnett adjustment.
\emph{Note} in all of these functions, it is illegal to have any overlap
between the \code{ref} levels and the \code{exclude} levels. If any
is found, an error is thrown.

\code{consec.emmc} and \code{mean_chg.emmc} are useful for contrasting
treatments that occur in sequence. For a factor with levels A, B, C, D, E,
\code{consec.emmc} generates the comparisons B-A, C-B, and D-C, while
\code{mean_chg.emmc} generates the contrasts (B+C+D)/3 - A, (C+D)/2 -
(A+B)/2, and D - (A+B+C)/3. With \code{reverse = TRUE}, these differences go
in the opposite direction.

\code{eff.emmc} and \code{del.eff.emmc} generate contrasts that compare each 
level with the average over all levels (in \code{eff.emmc}) or over all other
levels (in \code{del.eff.emmc}). These differ only in how they are scaled. 
For a set of k EMMs, \code{del.eff.emmc} gives weight 1 to one EMM and weight
-1/(k-1) to the others, while \code{eff.emmc} gives weights (k-1)/k and -1/k 
respectively, as in subtracting the overall EMM from each EMM. The default 
multiplicity adjustment method is \code{"fdr"}. This is a Bonferroni-based 
method and is slightly conservative; see \code{\link[stats]{p.adjust}}.
}
\note{
Caution is needed in cases where the user alters the ordering of
  results (e.g., using the the \code{"[...]"} operator), because the contrasts
  generated depend on the order of the levels provided. For example, suppose
  \code{trt.vs.ctrl1} contrasts are applied to two \code{by} groups with
  levels ordered (Ctrl, T1, T2) and (T1, T2, Ctrl) respectively, then the
  contrasts generated will be for (T1 - Ctrl, T2 - Ctrl) in the first group and
  (T2 - T1, Ctrl - T1) in the second group, because the first level in each group
  is used as the reference level.
}
\examples{
warp.lm <- lm(breaks ~ wool*tension, data = warpbreaks)
warp.emm <- emmeans(warp.lm, ~ tension | wool)
contrast(warp.emm, "poly")
contrast(warp.emm, "trt.vs.ctrl", ref = "M")

# Compare only low and high tensions
# Note pairs(emm, ...) calls contrast(emm, "pairwise", ...)
pairs(warp.emm, exclude = 2)
# (same results using exclude = "M" or include = c("L","H") or include = c(1,3))

### Setting up a custom contrast function
helmert.emmc <- function(levs, ...) {
    M <- as.data.frame(contr.helmert(levs))
    names(M) <- paste(levs[-1],"vs earlier")
    attr(M, "desc") <- "Helmert contrasts"
    M
}
contrast(warp.emm, "helmert")
\dontrun{
# See what is used for polynomial contrasts with 6 levels
emmeans:::poly.emmc(1:6)
}
}
