% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qdrg.R
\name{qdrg}
\alias{qdrg}
\title{Quick and dirty reference grid}
\usage{
qdrg(formula, data, coef, mcmc, vcov, object, df, subset, weights, contrasts,
  link, qr, ...)
}
\arguments{
\item{formula}{Formula for the fixed effects}

\item{data}{Dataset containing the variables in the model}

\item{coef}{Fixed-effect regression coefficients (must conform to formula)}

\item{mcmc}{Posterior sample of fixed-effect coefficients}

\item{vcov}{Variance-covariance matrix of the fixed effects}

\item{object}{Optional model object. If provided, it is used to set 
certain other arguments, if not specified. See Details.}

\item{df}{Error degrees of freedom}

\item{subset}{Subset of \code{data} used in fitting the model}

\item{weights}{Weights used in fitting the model}

\item{contrasts}{List of contrasts specified in fitting the model}

\item{link}{Link function (character or list) used, if a generalized linear model.
(Note: response transformations are auto-detected from \code{formula})}

\item{qr}{QR decomposition of the model matrix; needed only if there are \code{NA}s
in \code{coef}.}

\item{...}{Optional arguments passed to \code{\link{ref_grid}}}
}
\value{
An \code{emmGrid} object constructed from the arguments
}
\description{
This function may make it possible to compute a reference grid for a model 
object that is otherwise not supported.
}
\details{
If \code{object} is specified, it is used to try to obtain certain 
other arguments, as detailed below. The user should ensure that these defaults
will work. The default values for the arguments are as follows:
\itemize{
  \item{\code{formula}: }{Required unless obtainable via \code{formula(object)}}
  \item{\code{data}: }{Required if variables are not in \code{parent.frame()} or 
      obtainable via \code{object$data}}
  \item{\code{coef}: }{\code{coef(object)}}
  \item{\code{mcmc}: }{\code{object$sample}}
  \item{\code{vcov}: }{\code{vcov(object)}}
  \item{\code{df}: }{Set to \code{Inf} if not available in \code{object$df.residual}}
  \item{\code{subset}: }{\code{NULL} (so that all observations in \code{data} are used)}
  \item{\code{contrasts}: }{\code{NULL} (so that \code{getOption("contrasts")} is used)}
}

The functions \code{\link{qdrg}} and \code{emmobj} are close cousins, in that
they both produce \code{emmGrid} objects. When starting with summary
statistics for an existing grid, \code{emmobj} is more useful, while
\code{qdrg} is more useful when starting from a fitted model.
}
\examples{
if (require(biglm)) {
  # Post hoc analysis of a "biglm" object -- not supported by emmeans
  bigmod <- biglm(log(conc) ~ source + factor(percent), data = pigs)
   
  rg2 <- qdrg(object = bigmod, data = pigs)
  summary(emmeans(rg2, "source"), type = "response")
}
if(require(coda) && require(lme4)) {
  # Use a stored example having a posterior sample
  # Model is based on the data in lme4::cbpp
  
  post <- readRDS(system.file("extdata", "cbpplist", package = "emmeans"))$post.beta
  rg1 <- qdrg(~ size + period, data = lme4::cbpp, mcmc = post, link = "logit")
  summary(rg1, type = "response")
}

}
\seealso{
\code{\link{emmobj}} for an alternative way to construct an \code{emmGrid}.
}
