% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwpp.R
\name{pwpm}
\alias{pwpm}
\title{Pairwise P-value matrix (plus other statistics)}
\usage{
pwpm(emm, by, reverse = FALSE, pvals = TRUE, means = TRUE,
  diffs = TRUE, flip = FALSE, digits, ...)
}
\arguments{
\item{emm}{An \code{emmGrid} object}

\item{by}{Character vector of variable(s) in the grid to condition on. These
will create different matrices, one for each level or level-combination.
If missing, \code{by} is set to \code{emm@misc$by.vars}.
Grid factors not in \code{by} are the \emph{primary} factors:
whose levels or level combinations are compared pairwise.}

\item{reverse}{Logical value passed to \code{\link{pairs.emmGrid}}.
Thus, \code{FALSE} specifies \code{"pairwise"} comparisons 
(earlier vs. later), and \code{TRUE} specifies \code{"revpairwise"}
comparisons (later vs. earlier).}

\item{pvals}{Logical value. If \code{TRUE}, the pairwise differences 
of the EMMs are included in each matrix according to \code{flip}.}

\item{means}{Logical value. If \code{TRUE}, the estimated marginal means
(EMMs) from \code{emm} are included in the matrix diagonal(s).}

\item{diffs}{Logical value. If \code{TRUE}, the pairwise differences 
of the EMMs are included in each matrix according to \code{flip}.}

\item{flip}{Logical value that determines where P values and differences 
are placed. \code{FALSE} places the P values in the upper triangle
and differences in the lower, and \code{TRUE} does just the opposite.}

\item{digits}{Integer. Number of digits to display. If missing,
an optimal number of digits is determined.}

\item{...}{Additional arguments passed to \code{\link{contrast.emmGrid}} and 
\code{\link{summary.emmGrid}}. You should \emph{not} include \code{method}
here, because pairwise comparisons are always used.}
}
\value{
A matrix or `list` of matrices, one for each `by` level.
}
\description{
This function presents results from \code{emmeans} and pairwise comparisons
thereof in a compact way. It displays a matrix (or matrices) of estimates,
pairwise differences, and P values. The user may opt to exclude any of these
via arguments \code{means}, \code{diffs}, and \code{pvals}, respectively.
To control the direction of the pairwise differences, use \code{reverse};
and to control what appears in the upper and lower triangle(s), use \code{flip}.
Optional arguments are passed to \code{contrast.emmGrid} and/or 
\code{summary.emmGrid}, making it possible to control what estimates 
and tests are displayed.
}
\examples{
warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)
warp.emm <- emmeans(warp.lm, ~ tension | wool)

pwpm(warp.emm)

# use dot options to specify noninferiority tests
pwpm(warp.emm, by = NULL, side = ">", delta = 5, adjust = "none")
}
\seealso{
A graphical display of essentially the same results is available
  from \code{\link{pwpp}}
}
