% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-autoproc_annots.R
\name{replace_itemLabels}
\alias{replace_itemLabels}
\title{Replace item labels}
\usage{
replace_itemLabels(emuDBhandle, attributeDefinitionName, origLabels, newLabels,
  verbose = TRUE)
}
\arguments{
\item{emuDBhandle}{emuDB handle object (see \link{load_emuDB})}

\item{attributeDefinitionName}{name of a attributeDefinition of a emuDB where the labels are to be 
replaced}

\item{origLabels}{character vector containing labels that are to be replaced}

\item{newLabels}{character vector containing labels that are to replaced the labels of \code{origLabels}. 
This vector has to be of equal length to the \code{origLabels} vector.}

\item{verbose}{Show progress bars and further information}
}
\description{
Replace the labels of all annotation items, or more specifially 
of attribute definitions belonging to annotation items, in an emuDB that 
match the provided \code{origLabels} character vector which the 
corresponding labels provided by the \code{newLabels} character vector. 
The indicies of the label vectors provided are used to match the labels 
(i.e. \code{origLabels[i]} will be replaced by \code{newLabels[i]}).
}
\examples{
\dontrun{

##################################
# prerequisite: loaded ae emuDB 
# (see ?load_emuDB for more information)

# replace all "I" and "p" labels with "I_replaced" and "p_replaced"
replace_itemLabels(ae, attributeDefinitionName = "Phonetic", 
                       origLabels = c("I", "p"), 
                       newLabels = c("I_replaced", "p_replaced"))

}

}
\seealso{
\code{\link{load_emuDB}}
}
\keyword{emuDB}
