% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr.R
\name{cr}
\alias{cr}
\title{Plot digital sinuoids.}
\usage{
cr(A = 1, k = 1, p = 0, N = 16, samfreq = NULL,
  duration = NULL, const = NULL, expon = NULL, plotf = TRUE,
  ylim = NULL, xlim = NULL, values = FALSE,
  xlab = "Time (number of points)", ylab = "Amplitude", type = "b",
  bw = NULL, dopoints = FALSE, ...)
}
\arguments{
\item{A}{A vector of amplitude values. Defaults to A = 1}

\item{k}{A vector of cycles (repetitions). Defaults to k = 1}

\item{p}{A vector of phase values between -pi/2 and pi/2. Defaults to 0.}

\item{N}{The number of points in the signal. Defaults to 16.}

\item{samfreq}{If NULL, then a sinusoid is plotted with a frequency of k
cycles per N points. Otherwise, if samfreq is an numeric, then the argument
to k is interpreted as the frequency in Hz and the sinusoid at that
frequency is plotted for however many points are specified by N. For
example, if samfreq is 40 (Hz), and if N is 40 and k = 1, then 1 cycle of a
1 Hz sinusoid will be plotted.}

\item{duration}{Specify the duration in ms. If NULL, the default, then the
duration of the sinusoid is in points (N), otherwise if a numeric value is
supplied, then in ms. For example, 1/2 second of a 1 cycle sinusoid at a
sampling frequency of 40 Hz: duration = 500, k = 1, samfreq=40. A ms value
can be supplied only if the sampling frequency is also specified.}

\item{const}{A single numeric vector for shifting the entire sinusoid up or
down the y-axis. For example, when const is 5, then 5 + s, where s is the
sinusoid is plotted. Defaults to 0 (zero).}

\item{expon}{A numeric vector. If supplied, then what is plotted is
expon[j]\eqn{\mbox{\textasciicircum}}{^}(c(0:(N - 1) * A cos (2 * pi * k/N
* (0:(N-1))). For example, a decaying sinusoid is produced with
cr(expon=-0.9). Defaults to NULL (i.e. to expon = 1).}

\item{plotf}{A single-valued logical vector. If T (default), the sinusoid
is plotted.}

\item{ylim}{A two-valued numeric vector for specifying the y-axis range.}

\item{xlim}{A two-valued numeric vector for specifying the y-axis range.}

\item{values}{If T, then the values of the sinusoid are listed. Defaults to
F.}

\item{xlab}{A character vector for plotting the x-axis title.}

\item{ylab}{A character vector for plotting the y-axis title.}

\item{type}{A character vector for specifying the line type (see par)}

\item{bw}{A numeric vector for specifying the bandwidth, if the sampling
frequency is supplied. The bandwidth is converted to an exponential (see
expon using exp( - rad(bw/2, samfreq = samfreq).}

\item{dopoints}{this is now redundant.}

\item{\dots}{Option for supplying further graphical parameters - see par.}
}
\description{
The function plots and/or sums digital sinusoids for different parameter
settings.
}
\examples{

# cosine wave
cr()

# doubling the frequency, 1/3 amplitude, phase = pi/4, 50 points
cr(A=1/3, k=2, p=pi/4, N=50)

# sum 3 sinusoids of different frequencies)
cr(k=c(1, 3, 4))

# sum 2 sinusoids of different parameters
cr(c(1, 2), c(2, 10), c(0, -pi/3), N=200, type="l")


# store the above to a vector and overlay with noise
v = cr(c(1, 2), c(2, 10), c(0, -pi/3), N=200, type="l", values=TRUE)
r = runif(200, -3, 3)
v = v+r
plot(0:199, v, type="l")


# 100 points of a 50 Hz sinusoid with a 4 Hz bandwidth 
# at a sampling frequency of 200 Hz
cr(k=50, bw=4, samfreq=2000, N=100)

# the same but shift the y-axis by +4 (d.c. offset=+4)
cr(const=4, k=50, bw=4, samfreq=2000, N=100)

# sinusoid multiplied by a decaying exponential (same effect as bandwidth)
cr(expon=-0.95,  N=200, type="l")


}
\seealso{
\code{\link{crplot}}
}
\author{
Jonathan Harrington
}
\keyword{dplot}
