

#' Bigeochemical Cycling Models
#' 
#' A set of 43 biogeochemical cycling models compiled by the SEE Lab at UNCW.
#' 
#' 
#' @name bgcModels
#' @docType data
#' @references Borrett, S. R., and M. K. Lau. In Prep. enaR: An R package for
#' Ecological Network Analysis. Ecological Modeling and Software.
#' @keywords datasets
NULL





#' Ecosystem Model Information
#' 
#' Model information for the set of ecosystem models compiled by the SEE Lab at
#' UNCW.
#' 
#' 
#' @name enaModelInfo
#' @docType data
#' @references Borrett, S. R., and M. K. Lau. In Prep. enaR: An R package for
#' Ecological Network Analysis. Ecological Modeling and Software.
#' @keywords datasets
NULL





#' Ecosystem Models
#' 
#' A set of ecosystem models compiled by the SEE Lab at UNCW.
#' 
#' 
#' @name enaModels
#' @docType data
#' @references Borrett, S. R., and M. K. Lau. In Prep. enaR: An R package for
#' Ecological Network Analysis. Ecological Modeling and Software.
#' @keywords datasets
NULL





#' Tools for Ecological Network Analysis (ena)
#' 
#' This package compiles functions for the analysis of ecological networks,
#' building on tools previously developed in the MatLab language Borrett 2006)
#' with multiple additions of functionality.
#' 
#' \tabular{ll}{ Package: \tab enaR \cr Type: \tab Package\cr Version: \tab
#' 2.10\cr Date: \tab 2017-02-06\cr License: \tab GPL-3\cr }
#' 
#' @name enaR-package
#' @aliases enaR enaR-package
#' @docType package
#' @author Authors: Stuart R. Borrett, Matthew K. Lau, Pawandeep Singh, David
#' E. Hines Maintainer: Matthew K. Lau <enaR.maintainer@@gmail.com>
#' @seealso % ~~ Optional links to other man pages, e.g. ~~ % ~~
#' \code{\link[network:network-package]{network}}
#' @references Borrett SR and Lau MK 2014. enaR: An r package for Ecosystem
#' Network Analysis. Methods in Ecology and Evolution 5:1206-1213.
#' @keywords package
NULL





#' Sub-set of the Larger Ecosystem Models
#' 
#' A set of ecosystem models compiled by the SEE Lab at UNCW.
#' 
#' 
#' @name m.list
#' @docType data
#' @references Borrett, S. R., and M. K. Lau. In Prep. enaR: An R package for
#' Ecological Network Analysis. Ecological Modeling and Software.
#' @keywords datasets
NULL





#' Intertidal Oyster Reef Ecosystem Model
#' 
#' Intertidal oyster reef ecosystem model created by Dame and Patten (1981).
#' Data were taken from Patten (1985).  Model flows are in kcal m^-2 day^-1;
#' storage data is kcal m^-2.
#' 
#' 
#' @name oyster
#' @docType data
#' @references Dame, R. F., and B. C. Patten. 1981. Analysis of energy flows in
#' an intertidal oyster reef. Marine Ecology Progress Series 5:115-124.
#' 
#' Patten, B. C. 1985. Energy cycling, length of food chains, and direct versus
#' indirect effects in ecosystems. Can. Bull. Fish. Aqu. Sci. 213:119-138.
#' @keywords datasets
NULL





#' Trophic Models
#' 
#' A set of 58 trophic models compiled by the SEE Lab at UNCW.
#' 
#' 
#' @name troModels
#' @docType data
#' @references Borrett, S. R., and M. K. Lau. In Prep. enaR: An R package for
#' Ecological Network Analysis. Ecological Modeling and Software.
#' @keywords datasets
NULL



