% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TES.R
\name{TES}
\alias{TES}
\title{Calculates the Total Environ Storage}
\usage{
TES(x, balance.override = FALSE)
}
\arguments{
\item{x}{A network object.}

\item{balance.override}{LOGICAL: should balancing being ignored.}
}
\value{
\item{realized.input}{input oriented, realized storage in each
environ.} \item{realized.output}{output oriented, realized storage in each
environ.} \item{unit.input }{input oriented, unit storage in each environ.}
\item{unit.output}{input oriented, unit storage in each environ.}
}
\description{
Calculates the total storage in each n input and output environs. This function calculates the storage for both the unit input (output) and the realized input (output) environs.  Realized uses the observed inputs (outputs) rather than an assumed unit input (output) to each node.
}
\examples{
data(troModels)
tes <- TES(troModels[[6]])
tes
}
\references{
Matis, J.H. and Patten, B.C. 1981.  Environ analysis of linear
compartmenal systems: the static, time invariant case.  Bulletin of the
International Statistical Institute. 48, 527--565.
}
\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
\code{\link{enaStorage},\link{enaEnviron}}
}
\author{
Matthew K. Lau Stuart R. Borrett David E. Hines
}
