% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probit_linear_latent.R
\name{probit_linear_latent}
\alias{probit_linear_latent}
\title{Recursive Probit-Linear Model with Latent First Stage}
\usage{
probit_linear_latent(
  form_probit,
  form_linear,
  data = NULL,
  EM = TRUE,
  par = NULL,
  method = "BFGS",
  verbose = 0,
  accu = 10000,
  maxIter = 500,
  tol = 1e-06,
  tol_LL = 1e-08
)
}
\arguments{
\item{form_probit}{Formula for the first-stage probit model, in which the dependent variable is latent}

\item{form_linear}{Formula for the second stage linear model. The latent dependent variable of the first stage is automatically added as a regressor in this model}

\item{data}{Input data, a data frame}

\item{EM}{Whether to maximize likelihood use the Expectation-Maximization algorithm. EM is slower but more robust}

\item{par}{Starting values for estimates}

\item{method}{Optimization algorithm. Default is BFGS}

\item{verbose}{Level of output during estimation. Lowest is 0.}

\item{accu}{1e12 for low accuracy; 1e7 for moderate accuracy; 10.0 for extremely high accuracy. See optim}

\item{maxIter}{max iterations for EM algorithm}

\item{tol}{tolerance for convergence of EM algorithm}

\item{tol_LL}{tolerance for convergence of likelihood}
}
\value{
A list containing the results of the estimated model
}
\description{
The first stage is a probit model with unobserved dependent variable, the second stage is a linear model that includes the first-stage dependent variable as a regressor.
}
\examples{
\donttest{
library(MASS)
N = 2000
rho = -0.5
set.seed(1)

x = rbinom(N, 1, 0.5)
z = rnorm(N)

e = mvrnorm(N, mu=c(0,0), Sigma=matrix(c(1,rho,rho,1), nrow=2))
e1 = e[,1]
e2 = e[,2]

y1 = as.numeric(1 + x + z + e1 > 0)
y2 = 1 + x + z + y1 + e2
est = probit_linear(y1~x+z, y2~x+z+y1)
est$estimates

est_latent = probit_linear_latent(~x+z, y2~x+z)
est_latent$estimates
}
}
\references{
Peng, Jing. (2022) Identification of Causal Mechanisms from Randomized Experiments: A Framework for Endogenous Mediation Analysis. Information Systems Research (Forthcoming), Available at SSRN: https://ssrn.com/abstract=3494856
}
\seealso{
Other endogeneity: 
\code{\link{bilinear}()},
\code{\link{biprobit_latent}()},
\code{\link{biprobit_partial}()},
\code{\link{biprobit}()},
\code{\link{pln_linear}()},
\code{\link{pln_probit}()},
\code{\link{probit_linear_partial}()},
\code{\link{probit_linear}()}
}
\concept{endogeneity}
